/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountServerAggregator;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.iq80.snappy.Snappy;

public abstract class DistinctValueWithCountClientAggregator
extends BaseAggregator {
    protected Map<ImmutableBytesPtr, Integer> valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();
    protected byte[] buffer;
    protected long totalCount = 0L;
    protected Object cachedResult;

    public DistinctValueWithCountClientAggregator(SortOrder sortOrder) {
        super(sortOrder);
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (tuple instanceof SingleKeyValueTuple) {
            PDataType resultDataType = this.getResultDataType();
            this.cachedResult = resultDataType.toObject(ptr, resultDataType, this.sortOrder);
        } else {
            try {
                ByteArrayInputStream is;
                if (Bytes.equals((byte[])ptr.get(), (int)ptr.getOffset(), (int)1, (byte[])DistinctValueWithCountServerAggregator.COMPRESS_MARKER, (int)0, (int)1)) {
                    int uncompressedLength = Snappy.getUncompressedLength(ptr.get(), ptr.getOffset() + 1);
                    byte[] uncompressed = new byte[uncompressedLength];
                    Snappy.uncompress(ptr.get(), ptr.getOffset() + 1, ptr.getLength() - 1, uncompressed, 0);
                    is = new ByteArrayInputStream(uncompressed, 0, uncompressedLength);
                } else {
                    is = new ByteArrayInputStream(ptr.get(), ptr.getOffset() + 1, ptr.getLength() - 1);
                }
                DataInputStream in = new DataInputStream(is);
                int mapSize = WritableUtils.readVInt((DataInput)in);
                for (int i = 0; i < mapSize; ++i) {
                    int keyLen = WritableUtils.readVInt((DataInput)in);
                    byte[] keyBytes = new byte[keyLen];
                    in.read(keyBytes, 0, keyLen);
                    ImmutableBytesPtr key = new ImmutableBytesPtr(keyBytes);
                    int value = WritableUtils.readVInt((DataInput)in);
                    Integer curCount = this.valueVsCount.get((Object)key);
                    if (curCount == null) {
                        this.valueVsCount.put(key, value);
                    } else {
                        this.valueVsCount.put(key, curCount + value);
                    }
                    this.totalCount += (long)value;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        if (this.buffer == null) {
            this.initBuffer();
        }
    }

    protected void initBuffer() {
        this.buffer = new byte[this.getBufferLength()];
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    @Override
    public void reset() {
        this.valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();
        this.buffer = null;
        this.totalCount = 0L;
        this.cachedResult = null;
        super.reset();
    }

    protected Map<Object, Integer> getSortedValueVsCount(final boolean ascending, final PDataType type) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (ascending) {
                    return type.compareTo(o1, o2);
                }
                return type.compareTo(o2, o1);
            }
        };
        TreeMap<Object, Integer> sorted = new TreeMap<Object, Integer>(comparator);
        for (Map.Entry<ImmutableBytesPtr, Integer> entry : this.valueVsCount.entrySet()) {
            sorted.put(type.toObject((ImmutableBytesWritable)entry.getKey(), this.sortOrder), entry.getValue());
        }
        return sorted;
    }

    protected int getBufferLength() {
        return this.getResultDataType().getByteSize();
    }

    protected abstract PDataType getResultDataType();
}

