/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.lmax.disruptor.BlockingWaitStrategy;
import java.io.IOException;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.BatchPoolModule;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.LeaseManager;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.LowWatermarkWriterImpl;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.MonitoringContextImpl;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistenceProcessorHandler;
import org.apache.omid.tso.PersistenceProcessorImpl;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.ReplyProcessorImpl;
import org.apache.omid.tso.RetryProcessor;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.VoidLeaseManager;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.jboss.netty.channel.Channel;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPersistenceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestPersistenceProcessor.class);
    private static final long ANY_LWM = 1234L;
    private static final int ANY_ST = 0;
    private static final int ANY_CT = 1;
    @Mock
    private CommitTable.Writer mockWriter;
    @Mock
    private CommitTable.Client mockClient;
    @Mock
    private RetryProcessor retryProcessor;
    @Mock
    private Panicker panicker;
    private MetricsRegistry metrics;
    private CommitTable commitTable;
    private LowWatermarkWriter lowWatermarkWriter;

    @BeforeMethod(alwaysRun=true, timeOut=30000L)
    public void initMocksAndComponents() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.metrics = new NullMetricsProvider();
        this.commitTable = new CommitTable(){

            @Override
            public CommitTable.Writer getWriter() {
                return TestPersistenceProcessor.this.mockWriter;
            }

            @Override
            public CommitTable.Client getClient() {
                return TestPersistenceProcessor.this.mockClient;
            }
        };
    }

    @AfterMethod
    void afterMethod() {
        Mockito.reset((Object[])new CommitTable.Writer[]{this.mockWriter});
    }

    @Test(timeOut=30000L)
    public void testLowWatermarkIsPersisted() throws Exception {
        TSOServerConfig tsoConfig = new TSOServerConfig();
        this.lowWatermarkWriter = new LowWatermarkWriterImpl(tsoConfig, this.commitTable, this.metrics);
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[tsoConfig.getNumConcurrentCTWriters()];
        for (int i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)Mockito.mock(LeaseManager.class), this.commitTable, (ReplyProcessor)Mockito.mock(ReplyProcessor.class), this.retryProcessor, this.panicker);
        }
        PersistenceProcessorImpl persistenceProcessor = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)((ObjectPool)Mockito.mock(ObjectPool.class)), this.panicker, handlers, this.metrics);
        this.lowWatermarkWriter.persistLowWatermark(1234L).get();
        ArgumentCaptor lwmCapture = ArgumentCaptor.forClass(Long.class);
        CommitTable.Writer lwmWriter = this.commitTable.getWriter();
        ((CommitTable.Writer)Mockito.verify((Object)lwmWriter, (VerificationMode)Mockito.timeout((int)100).times(1))).updateLowWatermark((Long)lwmCapture.capture());
        Assert.assertEquals((long)((Long)lwmCapture.getValue()), (long)1234L);
    }

    @Test(timeOut=30000L)
    public void testCommitPersistenceWithSingleCommitTableWriter() throws Exception {
        boolean NUM_CT_WRITERS = true;
        int BATCH_SIZE_PER_CT_WRITER = 2;
        VoidLeaseManager leaseManager = (VoidLeaseManager)Mockito.spy((Object)new VoidLeaseManager((TSOChannelHandler)Mockito.mock(TSOChannelHandler.class), (TSOStateManager)Mockito.mock(TSOStateManager.class)));
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setBatchSizePerCTWriter(2);
        tsoConfig.setNumConcurrentCTWriters(1);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        ReplyProcessorImpl replyProcessor = new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, (ObjectPool<Batch>)batchPool, this.lowWatermarkWriter);
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[tsoConfig.getNumConcurrentCTWriters()];
        for (int i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", leaseManager, this.commitTable, replyProcessor, this.retryProcessor, this.panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)1))).borrowObject();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)3))).borrowObject();
    }

    @Test(timeOut=30000L)
    public void testCommitPersistenceWithMultipleCommitTableWriters() throws Exception {
        int NUM_CT_WRITERS = 2;
        int BATCH_SIZE_PER_CT_WRITER = 2;
        VoidLeaseManager leaseManager = (VoidLeaseManager)Mockito.spy((Object)new VoidLeaseManager((TSOChannelHandler)Mockito.mock(TSOChannelHandler.class), (TSOStateManager)Mockito.mock(TSOStateManager.class)));
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setBatchSizePerCTWriter(2);
        tsoConfig.setNumConcurrentCTWriters(2);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        ReplyProcessorImpl replyProcessor = new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, (ObjectPool<Batch>)batchPool, this.lowWatermarkWriter);
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[tsoConfig.getNumConcurrentCTWriters()];
        for (int i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", leaseManager, this.commitTable, replyProcessor, this.retryProcessor, this.panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)1))).borrowObject();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)2))).borrowObject();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContext.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContext.class), (Optional<Long>)Optional.absent());
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)3))).borrowObject();
        proc.triggerCurrentBatchFlush();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)3))).borrowObject();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)5))).borrowObject();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)5))).borrowObject();
        proc.triggerCurrentBatchFlush();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)6))).borrowObject();
        proc.triggerCurrentBatchFlush();
        proc.triggerCurrentBatchFlush();
        proc.triggerCurrentBatchFlush();
        proc.triggerCurrentBatchFlush();
        proc.triggerCurrentBatchFlush();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)6))).borrowObject();
    }

    @Test(timeOut=30000L)
    public void testCommitPersistenceWithNonHALeaseManager() throws Exception {
        boolean NUM_CT_WRITERS = true;
        boolean BATCH_SIZE_PER_CT_WRITER = true;
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setBatchSizePerCTWriter(1);
        tsoConfig.setNumConcurrentCTWriters(1);
        tsoConfig.setBatchPersistTimeoutInMs(100);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        ReplyProcessorImpl replyProcessor = new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, (ObjectPool<Batch>)batchPool, this.lowWatermarkWriter);
        VoidLeaseManager leaseManager = (VoidLeaseManager)Mockito.spy((Object)new VoidLeaseManager((TSOChannelHandler)Mockito.mock(TSOChannelHandler.class), (TSOStateManager)Mockito.mock(TSOStateManager.class)));
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[tsoConfig.getNumConcurrentCTWriters()];
        for (int i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", leaseManager, this.commitTable, replyProcessor, this.retryProcessor, this.panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((VoidLeaseManager)Mockito.verify((Object)leaseManager, (VerificationMode)Mockito.timeout((int)1000).times(2))).stillInLeasePeriod();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)2))).borrowObject();
    }

    @Test(timeOut=30000L)
    public void testCommitPersistenceWithHALeaseManagerAndMinimumCommitTableWriters() throws Exception {
        int NUM_PERSIST_HANDLERS = 2;
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setNumConcurrentCTWriters(2);
        this.testPersistenceWithHALeaseManagerPreservingLease(tsoConfig);
        this.testPersistenceWithHALeaseManagerFailingToPreserveLease1(tsoConfig);
        this.testPersistenceWithHALeaseManagerFailingToPreserveLease2(tsoConfig);
        this.testPersistenceWithHALeaseManagerFailingToPreserveLease3(tsoConfig);
    }

    @Test(timeOut=30000L)
    public void testCommitPersistenceWithHALeaseManagerAndMultipleCommitTableWriters() throws Exception {
        int NUM_CT_WRITERS = 4;
        int BATCH_SIZE_PER_CT_WRITER = 4;
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setNumConcurrentCTWriters(4);
        tsoConfig.setBatchSizePerCTWriter(4);
        tsoConfig.setBatchPersistTimeoutInMs(100);
        this.testPersistenceWithHALeaseManagerPreservingLease(tsoConfig);
        this.testPersistenceWithHALeaseManagerFailingToPreserveLease1(tsoConfig);
        this.testPersistenceWithHALeaseManagerFailingToPreserveLease2(tsoConfig);
        this.testPersistenceWithHALeaseManagerFailingToPreserveLease3(tsoConfig);
    }

    private void testPersistenceWithHALeaseManagerPreservingLease(TSOServerConfig tsoConfig) throws Exception {
        LeaseManager simulatedHALeaseManager = (LeaseManager)Mockito.mock(LeaseManager.class);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        PersistenceProcessorHandler[] handlers = this.configureHandlers(tsoConfig, simulatedHALeaseManager, (ObjectPool<Batch>)batchPool);
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        ((LeaseManager)Mockito.doReturn((Object)true).when((Object)simulatedHALeaseManager)).stillInLeasePeriod();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((LeaseManager)Mockito.verify((Object)simulatedHALeaseManager, (VerificationMode)Mockito.timeout((int)1000).times(2))).stillInLeasePeriod();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)2))).borrowObject();
    }

    private void testPersistenceWithHALeaseManagerFailingToPreserveLease1(TSOServerConfig tsoConfig) throws Exception {
        LeaseManager simulatedHALeaseManager = (LeaseManager)Mockito.mock(LeaseManager.class);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        PersistenceProcessorHandler[] handlers = this.configureHandlers(tsoConfig, simulatedHALeaseManager, (ObjectPool<Batch>)batchPool);
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        ((LeaseManager)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)simulatedHALeaseManager)).stillInLeasePeriod();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((LeaseManager)Mockito.verify((Object)simulatedHALeaseManager, (VerificationMode)Mockito.timeout((int)1000).times(2))).stillInLeasePeriod();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)2))).borrowObject();
    }

    private void testPersistenceWithHALeaseManagerFailingToPreserveLease2(TSOServerConfig tsoConfig) throws Exception {
        LeaseManager simulatedHALeaseManager = (LeaseManager)Mockito.mock(LeaseManager.class);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        PersistenceProcessorHandler[] handlers = this.configureHandlers(tsoConfig, simulatedHALeaseManager, (ObjectPool<Batch>)batchPool);
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        ((LeaseManager)Mockito.doReturn((Object)false).when((Object)simulatedHALeaseManager)).stillInLeasePeriod();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((LeaseManager)Mockito.verify((Object)simulatedHALeaseManager, (VerificationMode)Mockito.timeout((int)1000).times(1))).stillInLeasePeriod();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)2))).borrowObject();
    }

    private void testPersistenceWithHALeaseManagerFailingToPreserveLease3(TSOServerConfig tsoConfig) throws Exception {
        LeaseManager simulatedHALeaseManager = (LeaseManager)Mockito.mock(LeaseManager.class);
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        PersistenceProcessorHandler[] handlers = this.configureHandlers(tsoConfig, simulatedHALeaseManager, (ObjectPool<Batch>)batchPool);
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(tsoConfig, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        ((CommitTable.Writer)Mockito.doThrow((Throwable)new IOException("Unable to write")).when((Object)this.mockWriter)).flush();
        ((LeaseManager)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)simulatedHALeaseManager)).stillInLeasePeriod();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), (MonitoringContext)Mockito.mock(MonitoringContextImpl.class), (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((LeaseManager)Mockito.verify((Object)simulatedHALeaseManager, (VerificationMode)Mockito.timeout((int)1000).times(1))).stillInLeasePeriod();
        ((ObjectPool)Mockito.verify((Object)batchPool, (VerificationMode)Mockito.times((int)2))).borrowObject();
    }

    private PersistenceProcessorHandler[] configureHandlers(TSOServerConfig tsoConfig, LeaseManager leaseManager, ObjectPool<Batch> batchPool) throws Exception {
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[tsoConfig.getNumConcurrentCTWriters()];
        for (int i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", leaseManager, this.commitTable, new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, batchPool, this.lowWatermarkWriter), this.retryProcessor, new RuntimeExceptionPanicker());
        }
        return handlers;
    }

    @Test(timeOut=30000L)
    public void testCommitTableExceptionOnCommitPersistenceTakesDownDaemon() throws Exception {
        LeaseManagement leaseManager = (LeaseManagement)Mockito.mock(LeaseManagement.class);
        TSOServerConfig config = new TSOServerConfig();
        ObjectPool batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(config).getBatchPool());
        ReplyProcessorImpl replyProcessor = new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, (ObjectPool<Batch>)batchPool, this.lowWatermarkWriter);
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[config.getNumConcurrentCTWriters()];
        for (int i = 0; i < config.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", leaseManager, this.commitTable, replyProcessor, (RetryProcessor)Mockito.mock(RetryProcessor.class), this.panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(config, new BlockingWaitStrategy(), this.commitTable, (ObjectPool<Batch>)batchPool, this.panicker, handlers, this.metrics);
        MonitoringContextImpl monCtx = new MonitoringContextImpl(this.metrics);
        ((LeaseManagement)Mockito.doReturn((Object)true).when((Object)leaseManager)).stillInLeasePeriod();
        ((CommitTable.Writer)Mockito.doThrow((Throwable)new IOException("Unable to write@TestPersistenceProcessor2")).when((Object)this.mockWriter)).flush();
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), monCtx, (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((Panicker)Mockito.verify((Object)this.panicker, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }

    @Test(timeOut=30000L)
    public void testRuntimeExceptionOnCommitPersistenceTakesDownDaemon() throws Exception {
        TSOServerConfig config = new TSOServerConfig();
        ObjectPool<Batch> batchPool = new BatchPoolModule(config).getBatchPool();
        ReplyProcessorImpl replyProcessor = new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, batchPool, this.lowWatermarkWriter);
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[config.getNumConcurrentCTWriters()];
        for (int i = 0; i < config.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)Mockito.mock(LeaseManager.class), this.commitTable, replyProcessor, this.retryProcessor, this.panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(config, new BlockingWaitStrategy(), this.commitTable, batchPool, this.panicker, handlers, this.metrics);
        ((CommitTable.Writer)Mockito.doThrow((Throwable)new RuntimeException("Kaboom!")).when((Object)this.mockWriter)).addCommittedTransaction(Matchers.anyLong(), Matchers.anyLong());
        MonitoringContextImpl monCtx = new MonitoringContextImpl(this.metrics);
        proc.addCommitToBatch(0L, 1L, (Channel)Mockito.mock(Channel.class), monCtx, (Optional<Long>)Optional.absent());
        proc.triggerCurrentBatchFlush();
        ((Panicker)Mockito.verify((Object)this.panicker, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }
}

