/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmTypeDefinitionImpl
extends EdmTypeImpl
implements EdmTypeDefinition {
    private CsdlTypeDefinition typeDefinition;
    private EdmPrimitiveType edmPrimitiveTypeInstance;

    public EdmTypeDefinitionImpl(Edm edm, FullQualifiedName typeDefinitionName, CsdlTypeDefinition typeDefinition) {
        super(edm, typeDefinitionName, EdmTypeKind.DEFINITION, (CsdlAnnotatable)typeDefinition);
        this.typeDefinition = typeDefinition;
    }

    public EdmPrimitiveType getUnderlyingType() {
        if (this.edmPrimitiveTypeInstance == null) {
            try {
                if (this.typeDefinition.getUnderlyingType() == null) {
                    throw new EdmException("Underlying Type for type definition: " + this.typeName.getFullQualifiedNameAsString() + " must not be null.");
                }
                this.edmPrimitiveTypeInstance = EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.valueOfFQN((String)this.typeDefinition.getUnderlyingType()));
            }
            catch (IllegalArgumentException e) {
                throw new EdmException("Invalid underlying type: " + this.typeDefinition.getUnderlyingType(), (Exception)e);
            }
        }
        return this.edmPrimitiveTypeInstance;
    }

    public Integer getMaxLength() {
        return this.typeDefinition.getMaxLength();
    }

    public Integer getPrecision() {
        return this.typeDefinition.getPrecision();
    }

    public Integer getScale() {
        return this.typeDefinition.getScale();
    }

    public SRID getSrid() {
        return this.typeDefinition.getSrid();
    }

    public Boolean isUnicode() {
        return this.typeDefinition.isUnicode();
    }

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this == primitiveType || this.getUnderlyingType().isCompatible(primitiveType);
    }

    public Class<?> getDefaultType() {
        return this.getUnderlyingType().getDefaultType();
    }

    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return this.getUnderlyingType().validate(value, isNullable, maxLength == null ? this.getMaxLength() : maxLength, precision == null ? this.getPrecision() : precision, scale == null ? this.getScale() : scale, isUnicode == null ? this.isUnicode() : isUnicode);
    }

    public <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        return (T)this.getUnderlyingType().valueOfString(value, isNullable, maxLength == null ? this.getMaxLength() : maxLength, precision == null ? this.getPrecision() : precision, scale == null ? this.getScale() : scale, isUnicode == null ? this.isUnicode() : isUnicode, returnType);
    }

    public String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        return this.getUnderlyingType().valueToString(value, isNullable, maxLength == null ? this.getMaxLength() : maxLength, precision == null ? this.getPrecision() : precision, scale == null ? this.getScale() : scale, isUnicode == null ? this.isUnicode() : isUnicode);
    }

    public String toUriLiteral(String literal) {
        return this.getUnderlyingType().toUriLiteral(literal);
    }

    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        return this.getUnderlyingType().fromUriLiteral(literal);
    }
}

