/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm.api;

import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCA;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMAT;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectByteCharSequence;

public interface MemoryCARW
extends MemoryCR,
MemoryARW,
MemoryCA,
MemoryMAT {
    @Override
    default public long getAddress() {
        return this.getPageAddress(0);
    }

    @Override
    default public long putBin(BinarySequence value) {
        if (value != null) {
            long len = value.length();
            long addr = this.appendAddressFor(len + 8L);
            Unsafe.getUnsafe().putLong(addr, len);
            value.copyTo(addr + 8L, 0L, len);
            return this.getAppendOffset();
        }
        return this.putNullBin();
    }

    @Override
    default public long putBin(long from, long len) {
        if (len > 0L) {
            long addr = this.appendAddressFor(len + 8L);
            Unsafe.getUnsafe().putLong(addr, len);
            Vect.memcpy(addr + 8L, from, len);
            return this.getAppendOffset();
        }
        return this.putNullBin();
    }

    @Override
    default public void putBlockOfBytes(long from, long len) {
        Vect.memcpy(this.appendAddressFor(len), from, len);
    }

    @Override
    default public void putBool(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    @Override
    default public void putBool(long offset, boolean value) {
        this.putByte(offset, (byte)(value ? 1 : 0));
    }

    @Override
    default public void putByte(byte value) {
        Unsafe.getUnsafe().putByte(this.appendAddressFor(1L), value);
    }

    @Override
    default public void putByte(long offset, byte value) {
        Unsafe.getUnsafe().putByte(this.appendAddressFor(offset, 1L), value);
    }

    @Override
    default public void putChar(char value) {
        Unsafe.getUnsafe().putChar(this.appendAddressFor(2L), value);
    }

    @Override
    default public void putChar(long offset, char value) {
        Unsafe.getUnsafe().putChar(this.appendAddressFor(offset, 2L), value);
    }

    @Override
    default public void putDouble(double value) {
        Unsafe.getUnsafe().putDouble(this.appendAddressFor(8L), value);
    }

    @Override
    default public void putDouble(long offset, double value) {
        Unsafe.getUnsafe().putDouble(this.appendAddressFor(offset, 8L), value);
    }

    @Override
    default public void putFloat(float value) {
        Unsafe.getUnsafe().putFloat(this.appendAddressFor(4L), value);
    }

    @Override
    default public void putFloat(long offset, float value) {
        Unsafe.getUnsafe().putFloat(this.appendAddressFor(offset, 4L), value);
    }

    @Override
    default public void putInt(int value) {
        Unsafe.getUnsafe().putInt(this.appendAddressFor(4L), value);
    }

    @Override
    default public void putInt(long offset, int value) {
        Unsafe.getUnsafe().putInt(this.appendAddressFor(offset, 4L), value);
    }

    @Override
    default public void putLong(long value) {
        Unsafe.getUnsafe().putLong(this.appendAddressFor(8L), value);
    }

    @Override
    default public void putLong(long offset, long value) {
        Unsafe.getUnsafe().putLong(this.appendAddressFor(offset, 8L), value);
    }

    @Override
    default public void putLong128(long lo, long hi) {
        long addr = this.appendAddressFor(16L);
        Unsafe.getUnsafe().putLong(addr, lo);
        Unsafe.getUnsafe().putLong(addr + 8L, hi);
    }

    @Override
    default public void putLong256(long l0, long l1, long l2, long l3) {
        long addr = this.appendAddressFor(32L);
        Unsafe.getUnsafe().putLong(addr, l0);
        Unsafe.getUnsafe().putLong(addr + 8L, l1);
        Unsafe.getUnsafe().putLong(addr + 16L, l2);
        Unsafe.getUnsafe().putLong(addr + 24L, l3);
    }

    @Override
    default public void putLong256(Long256 value) {
        this.putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    @Override
    default public void putLong256(CharSequence hexString) {
        int len;
        if (hexString == null || (len = hexString.length()) == 0) {
            this.putLong256Null();
        } else {
            this.putLong256(hexString, 2, len);
        }
    }

    @Override
    default public void putLong256(long offset, Long256 value) {
        this.putLong256(offset, value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    @Override
    default public void putLong256(long offset, long l0, long l1, long l2, long l3) {
        long addr = this.appendAddressFor(offset, 32L);
        Unsafe.getUnsafe().putLong(addr, l0);
        Unsafe.getUnsafe().putLong(addr + 8L, l1);
        Unsafe.getUnsafe().putLong(addr + 16L, l2);
        Unsafe.getUnsafe().putLong(addr + 24L, l3);
    }

    default public void putLong256(CharSequence hexString, int start, int end, Long256Acceptor acceptor) {
        Long256FromCharSequenceDecoder.decode(hexString, start, end, acceptor);
    }

    default public void putLong256Null() {
        Long256Impl.putNull(this.appendAddressFor(32L));
    }

    @Override
    default public long putNullBin() {
        this.putLong(-1L);
        return this.getAppendOffset();
    }

    @Override
    default public long putNullStr() {
        this.putInt(-1);
        return this.getAppendOffset();
    }

    @Override
    default public void putNullStr(long offset) {
        this.putInt(offset, -1);
    }

    @Override
    default public void putShort(short value) {
        Unsafe.getUnsafe().putShort(this.appendAddressFor(2L), value);
    }

    @Override
    default public void putShort(long offset, short value) {
        Unsafe.getUnsafe().putShort(this.appendAddressFor(offset, 2L), value);
    }

    @Override
    default public long putStr(CharSequence value) {
        return value != null ? this.putStrUnsafe(value, 0, value.length()) : this.putNullStr();
    }

    @Override
    default public long putStr(char value) {
        if (value != '\u0000') {
            long addr = this.appendAddressFor(6L);
            Unsafe.getUnsafe().putInt(addr, 1);
            Unsafe.getUnsafe().putChar(addr + 4L, value);
            return this.getAppendOffset();
        }
        return this.putNullStr();
    }

    @Override
    default public long putStr(CharSequence value, int pos, int len) {
        if (value != null) {
            return this.putStrUnsafe(value, pos, len);
        }
        return this.putNullStr();
    }

    @Override
    default public void putStr(long offset, CharSequence value) {
        if (value != null) {
            this.putStr(offset, value, 0, value.length());
        } else {
            this.putNullStr(offset);
        }
    }

    @Override
    default public void putStr(long offset, CharSequence value, int pos, int len) {
        long addr = this.appendAddressFor(offset, Vm.getStorageLength(len));
        Unsafe.getUnsafe().putInt(addr, len);
        Chars.copyStrChars(value, pos, len, addr + 4L);
    }

    default public long putStrUnsafe(CharSequence value, int pos, int len) {
        long storageLen = Vm.getStorageLength(len);
        long addr = this.appendAddressFor(storageLen);
        Unsafe.getUnsafe().putInt(addr, len);
        Chars.copyStrChars(value, pos, len, addr + 4L);
        return this.getAppendOffset();
    }

    @Override
    default public long putStrUtf8AsUtf16(DirectByteCharSequence value, boolean hasNonAsciiChars) {
        throw new UnsupportedOperationException();
    }
}

