/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiResultSetMetaData;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.adapter.SQLResultSet;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnarBatchRow;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowUtils;

public abstract class KyuubiArrowBasedResultSet
implements SQLResultSet {
    protected Statement statement = null;
    protected SQLWarning warningChain = null;
    protected boolean wasNull = false;
    protected List<String> columnNames;
    protected List<String> normalizedColumnNames;
    protected List<TTypeId> columnTypes;
    protected List<JdbcColumnAttributes> columnAttributes;
    private TTableSchema schema;
    protected Schema arrowSchema;
    protected VectorSchemaRoot root;
    protected ArrowColumnarBatchRow row;
    protected boolean timestampAsString = true;
    protected BufferAllocator allocator;

    protected void initArrowSchemaAndAllocator() {
        if (this.arrowSchema == null) {
            throw new IllegalStateException("arrow schema is null");
        }
        this.allocator = ArrowUtils.rootAllocator.newChildAllocator("ArrowResultSet", 0L, Long.MAX_VALUE);
        this.root = VectorSchemaRoot.create((Schema)this.arrowSchema, (BufferAllocator)this.allocator);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int columnIndex = 0;
        boolean findColumn = false;
        for (String normalizedColumnName : this.normalizedColumnNames) {
            ++columnIndex;
            String[] names = normalizedColumnName.split("\\.");
            String name = names[names.length - 1];
            if (!name.equalsIgnoreCase(columnName) && !normalizedColumnName.equalsIgnoreCase(columnName)) continue;
            findColumn = true;
            break;
        }
        if (!findColumn) {
            throw new KyuubiSQLException("Could not find " + columnName + " in " + this.normalizedColumnNames);
        }
        return columnIndex;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        if (val == null || val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        throw new KyuubiSQLException("Illegal conversion");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        MathContext mc = new MathContext(scale);
        return this.getBigDecimal(columnIndex).round(mc);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            byte[] byteArray = (byte[])obj;
            return new ByteArrayInputStream(byteArray);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        }
        throw new KyuubiSQLException("Illegal conversion to binary stream from column " + columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        if (obj instanceof String) {
            return !obj.equals("0");
        }
        throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to boolean");
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj == null) {
            return 0;
        }
        throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to byte");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        try {
            if (obj instanceof String) {
                return Date.valueOf((String)obj);
            }
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to date: " + e, e);
        }
        throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to date: Illegal conversion");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date value = this.getDate(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return this.parseDate(value, cal);
        }
        catch (IllegalArgumentException e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to date: " + e, e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    private Date parseDate(Date value, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.setTime(value);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj == null) {
                return 0.0;
            }
            if (obj instanceof String) {
                return Double.parseDouble((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to double: " + e, e);
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj == null) {
                return 0.0f;
            }
            if (obj instanceof String) {
                return Float.parseFloat((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to float: " + e, e);
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj == null) {
                return 0;
            }
            if (obj instanceof String) {
                return Integer.parseInt((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to integer" + e, e);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj == null) {
                return 0L;
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to long: " + e, e);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new KyuubiResultSetMetaData(this.columnNames, this.columnTypes, this.columnAttributes);
    }

    private Object getColumnValue(int columnIndex) throws SQLException {
        if (this.row == null) {
            throw new KyuubiSQLException("No row found.");
        }
        if (this.row.numFields() == 0) {
            throw new KyuubiSQLException("RowSet does not contain any columns!");
        }
        if (columnIndex > this.columnNames.size()) {
            throw new KyuubiSQLException("Invalid columnIndex: " + columnIndex);
        }
        TTypeId columnType = this.columnTypes.get(columnIndex - 1);
        try {
            this.wasNull = this.row.isNullAt(columnIndex - 1);
            if (this.wasNull) {
                return null;
            }
            JdbcColumnAttributes attributes = this.columnAttributes.get(columnIndex - 1);
            return this.row.get(columnIndex - 1, columnType, attributes == null ? null : attributes.timeZone, this.timestampAsString);
        }
        catch (Exception e) {
            throw new KyuubiSQLException(String.format("Error getting row of type %s at column index %d", columnType, columnIndex - 1), e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            if (obj == null) {
                return 0;
            }
            if (obj instanceof String) {
                return Short.parseShort((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to short: " + e, e);
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getColumnValue(columnIndex);
        if (this.wasNull) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof String) {
            return Timestamp.valueOf((String)obj);
        }
        throw new KyuubiSQLException("Illegal conversion");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp value = this.getTimestamp(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return this.parseTimestamp(value, cal);
        }
        catch (IllegalArgumentException e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to timestamp: " + e, e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    private Timestamp parseTimestamp(Timestamp timestamp, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        long v = timestamp.getTime();
        cal.setTimeInMillis(v);
        timestamp = new Timestamp(cal.getTime().getTime());
        return timestamp;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof String) {
            return Time.valueOf((String)obj);
        }
        throw new KyuubiSQLException("Illegal conversion");
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time value = this.getTime(columnIndex);
        if (value == null) {
            return null;
        }
        try {
            return this.parseTime(value, cal);
        }
        catch (IllegalArgumentException e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to time: " + e, e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    private Time parseTime(Time date, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        long v = date.getTime();
        cal.setTimeInMillis(v);
        date = new Time(cal.getTime().getTime());
        return date;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    protected void setSchema(TTableSchema schema) {
        this.schema = schema;
    }

    protected TTableSchema getSchema() {
        return this.schema;
    }

    @Override
    public void close() throws SQLException {
        if (this.root != null) {
            this.root.close();
        }
        if (this.allocator != null) {
            this.allocator.close();
        }
    }
}

