/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.security.cert.X509Certificate;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.http.credentials.X509Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CredentialsExtractor
implements CredentialsExtractor<X509Credentials> {
    public static final String CERTIFICATE_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final Logger logger = LoggerFactory.getLogger(X509CredentialsExtractor.class);

    public X509Credentials extract(WebContext context) {
        X509Certificate[] certificates = (X509Certificate[])context.getRequestAttribute(CERTIFICATE_REQUEST_ATTRIBUTE);
        if (certificates != null && certificates.length > 0) {
            X509Certificate certificate = certificates[0];
            logger.debug("X509 certificate: {}", (Object)certificate);
            return new X509Credentials(certificate);
        }
        logger.debug("No X509 certificate in request");
        return null;
    }
}

