/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.pac4j.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.util.Urls;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.JavaSerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxSessionStore
implements SessionStore {
    private static final Logger logger = LoggerFactory.getLogger(KnoxSessionStore.class);
    public static final String PAC4J_PASSWORD = "pac4j.password";
    public static final String PAC4J_SESSION_PREFIX = "pac4j.session.";
    private final JavaSerializationHelper javaSerializationHelper = new JavaSerializationHelper();
    private final CryptoService cryptoService;
    private final String clusterName;
    private final String domainSuffix;

    public KnoxSessionStore(CryptoService cryptoService, String clusterName, String domainSuffix) {
        this.cryptoService = cryptoService;
        this.clusterName = clusterName;
        this.domainSuffix = domainSuffix;
    }

    public String getOrCreateSessionId(WebContext context) {
        return null;
    }

    private Serializable uncompressDecryptBase64(String v) {
        if (v != null && !v.isEmpty()) {
            byte[] bytes = Base64.decodeBase64((String)v);
            EncryptionResult result = EncryptionResult.fromByteArray((byte[])bytes);
            byte[] clear = this.cryptoService.decryptForCluster(this.clusterName, PAC4J_PASSWORD, result.cipher, result.iv, result.salt);
            if (clear != null) {
                try {
                    return this.javaSerializationHelper.unserializeFromBytes(KnoxSessionStore.unCompress(clear));
                }
                catch (IOException e) {
                    throw new TechnicalException((Throwable)e);
                }
            }
        }
        return null;
    }

    public Object get(WebContext context, String key) {
        Cookie cookie = ContextHelper.getCookie((WebContext)context, (String)(PAC4J_SESSION_PREFIX + key));
        Serializable value = null;
        if (cookie != null) {
            value = this.uncompressDecryptBase64(cookie.getValue());
        }
        logger.debug("Get from session: {} = {}", (Object)key, (Object)value);
        return value;
    }

    private String compressEncryptBase64(Object o) {
        if (o == null || o.equals("") || o instanceof Map && ((Map)o).isEmpty()) {
            return null;
        }
        byte[] bytes = this.javaSerializationHelper.serializeToBytes((Serializable)o);
        try {
            bytes = KnoxSessionStore.compress(bytes);
            if (bytes.length > 3000) {
                logger.warn("Cookie too big, it might not be properly set");
            }
        }
        catch (IOException e) {
            throw new TechnicalException((Throwable)e);
        }
        EncryptionResult result = this.cryptoService.encryptForCluster(this.clusterName, PAC4J_PASSWORD, bytes);
        return Base64.encodeBase64String((byte[])result.toByteAray());
    }

    public void set(WebContext context, String key, Object value) {
        Cookie cookie;
        Object profile = value;
        if (value == null) {
            cookie = new Cookie(PAC4J_SESSION_PREFIX + key, null);
        } else {
            if (key.contentEquals("pac4jUserProfiles")) {
                profile = this.clearUserProfile(value);
            }
            logger.debug("Save in session: {} = {}", (Object)key, profile);
            cookie = new Cookie(PAC4J_SESSION_PREFIX + key, this.compressEncryptBase64(profile));
        }
        try {
            String domain = Urls.getDomainName((String)context.getFullRequestURL(), (String)this.domainSuffix);
            if (domain == null) {
                domain = context.getServerName();
            }
            cookie.setDomain(domain);
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
        cookie.setHttpOnly(true);
        cookie.setSecure(ContextHelper.isHttpsOrSecure((WebContext)context));
        if (context.getPath() != null && context.getPath().contains("pac4jCallback")) {
            String[] parts = ((J2EContext)context).getRequest().getRequestURI().split("websso/pac4jCallback");
            cookie.setPath(parts[0]);
        }
        context.addResponseCookie(cookie);
    }

    private static byte[] compress(byte[] data) throws IOException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);){
            try (GZIPOutputStream gzip = new GZIPOutputStream(byteStream);){
                gzip.write(data);
            }
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] unCompress(byte[] data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object clearUserProfile(Object value) {
        if (value instanceof Map) {
            Map profiles = (Map)value;
            profiles.forEach((name, profile) -> profile.clearSensitiveData());
            return profiles;
        }
        CommonProfile profile2 = (CommonProfile)value;
        profile2.clearSensitiveData();
        return profile2;
    }

    public SessionStore buildFromTrackableSession(WebContext arg0, Object arg1) {
        return null;
    }

    public boolean destroySession(WebContext arg0) {
        return false;
    }

    public Object getTrackableSession(WebContext arg0) {
        return null;
    }

    public boolean renewSession(WebContext context) {
        return false;
    }
}

