/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TimeWindowCollectSupportDataLogCaptureWindow
extends CollectSupportDataLogCaptureWindow {
    private static final long serialVersionUID = -989944420134047411L;
    @NotNull
    private final ASN1Element encodedWindow;
    @Nullable
    private final Long endTimeMillis;
    private final long startTimeMillis;

    public TimeWindowCollectSupportDataLogCaptureWindow(@NotNull Date startTime, @Nullable Date endTime) {
        this(startTime.getTime(), endTime == null ? null : Long.valueOf(endTime.getTime()));
    }

    public TimeWindowCollectSupportDataLogCaptureWindow(long startTimeMillis, @Nullable Long endTimeMillis) {
        Validator.ensureTrue(startTimeMillis > 0L, "TimeWindowCollectSupportDataLogCaptureWindow.startTimeMillis must be greater than zero.");
        if (endTimeMillis != null) {
            Validator.ensureTrue(endTimeMillis >= startTimeMillis, "If it is provided, thenTimeWindowCollectSupportDataLogCaptureWindow.endTime must greater than or equal to TimeWindowCollectSupportDataLogCaptureWindow.endTime.");
        }
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.encodedWindow = endTimeMillis == null ? new ASN1Sequence(-94, new ASN1OctetString(StaticUtils.encodeGeneralizedTime(startTimeMillis))) : new ASN1Sequence(-94, new ASN1OctetString(StaticUtils.encodeGeneralizedTime(startTimeMillis)), new ASN1OctetString(StaticUtils.encodeGeneralizedTime(endTimeMillis)));
    }

    @NotNull
    public Date getStartTime() {
        return new Date(this.startTimeMillis);
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Nullable
    public Date getEndTime() {
        if (this.endTimeMillis == null) {
            return null;
        }
        return new Date(this.endTimeMillis);
    }

    @Nullable
    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    @NotNull
    static TimeWindowCollectSupportDataLogCaptureWindow decodeInternal(@NotNull ASN1Element e) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(e).elements();
            if (elements.length == 1) {
                long startTimeMillis = TimeWindowCollectSupportDataLogCaptureWindow.decodeGeneralizedTimeString(elements[0]);
                return new TimeWindowCollectSupportDataLogCaptureWindow(startTimeMillis, null);
            }
            if (elements.length == 2) {
                long startTimeMillis = TimeWindowCollectSupportDataLogCaptureWindow.decodeGeneralizedTimeString(elements[0]);
                long endTimeMillis = TimeWindowCollectSupportDataLogCaptureWindow.decodeGeneralizedTimeString(elements[1]);
                return new TimeWindowCollectSupportDataLogCaptureWindow(startTimeMillis, endTimeMillis);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_TIME_WINDOW_CSD_LOG_WINDOW_INVALID_ELEMENT_COUNT.get(elements.length));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_TIME_WINDOW_CSD_LOG_WINDOW_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
    }

    private static long decodeGeneralizedTimeString(@NotNull ASN1Element e) throws LDAPException {
        String timestampString = ASN1OctetString.decodeAsOctetString(e).stringValue();
        try {
            return StaticUtils.decodeGeneralizedTime(timestampString).getTime();
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_TIME_WINDOW_CSD_LOG_WINDOW_MALFORMED_GT.get(timestampString), ex);
        }
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        return this.encodedWindow;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TimeWindowCollectSupportDataLogCaptureWindow(startTime='");
        buffer.append(StaticUtils.encodeGeneralizedTime(this.startTimeMillis));
        buffer.append('\'');
        if (this.endTimeMillis != null) {
            buffer.append(", endTime='");
            buffer.append(StaticUtils.encodeGeneralizedTime(this.endTimeMillis));
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

