/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.loader.mapping.LoadMapping;
import org.apache.hugegraph.loader.util.MappingUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class MappingConverter {
    private static final Logger LOG = Log.logger(MappingConverter.class);

    public static void main(String[] args) {
        E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"args: file", (Object[])new Object[0]);
        String input = args[0];
        LOG.info("Prepare to convert mapping file {}", (Object)input);
        File file = FileUtils.getFile((String[])new String[]{input});
        if (!file.exists() || !file.isFile()) {
            LOG.error("The file '{}' doesn't exists or not a file", (Object)input);
            throw new IllegalArgumentException(String.format("The file '%s' doesn't exists or not a file", input));
        }
        LoadMapping mapping = LoadMapping.of(input);
        String outputPath = MappingConverter.getOutputPath(file);
        MappingUtil.write(mapping, outputPath);
        LOG.info("Convert mapping file successfully, stored at {}", (Object)outputPath);
    }

    public static String getOutputPath(File file) {
        String fileName = file.getName();
        String prefix = fileName.substring(0, fileName.lastIndexOf("."));
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String newFileName = prefix + "-v2" + suffix;
        if (file.getParent() != null) {
            return Paths.get(file.getParent(), newFileName).toString();
        }
        return newFileName;
    }
}

