/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.util.ArrayList;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;

public class CoGroupByKey<K>
extends PTransform<KeyedPCollectionTuple<K>, PCollection<KV<K, CoGbkResult>>> {
    public static <K> CoGroupByKey<K> create() {
        return new CoGroupByKey<K>();
    }

    private CoGroupByKey() {
    }

    @Override
    public PCollection<KV<K, CoGbkResult>> expand(KeyedPCollectionTuple<K> input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("must have at least one input to a KeyedPCollections");
        }
        ArrayList codersList = new ArrayList();
        for (KeyedPCollectionTuple.TaggedKeyedPCollection<K, ?> entry : input.getKeyedCollections()) {
            codersList.add(this.getValueCoder(entry.pCollection));
        }
        UnionCoder unionCoder = UnionCoder.of(codersList);
        Coder<K> keyCoder = input.getKeyCoder();
        KvCoder<K, RawUnionValue> kVCoder = KvCoder.of(keyCoder, unionCoder);
        PCollectionList unionTables = PCollectionList.empty(input.getPipeline());
        int index = -1;
        for (KeyedPCollectionTuple.TaggedKeyedPCollection<K, ?> entry : input.getKeyedCollections()) {
            PCollection unionTable = this.makeUnionTable(++index, entry.pCollection, kVCoder);
            unionTables = unionTables.and(unionTable);
        }
        PCollection flattenedTable = (PCollection)unionTables.apply("Flatten", Flatten.pCollections());
        PCollection groupedTable = (PCollection)flattenedTable.apply("GBK", GroupByKey.create());
        CoGbkResultSchema tupleTags = input.getCoGbkResultSchema();
        PCollection result = (PCollection)groupedTable.apply("ConstructCoGbkResultFn", ParDo.of(new ConstructCoGbkResultFn(tupleTags)));
        result.setCoder(KvCoder.of(keyCoder, CoGbkResult.CoGbkResultCoder.of(tupleTags, unionCoder)));
        return result;
    }

    private <V> Coder<V> getValueCoder(PCollection<KV<K, V>> pCollection) {
        Coder<KV<K, V>> entryCoder = pCollection.getCoder();
        if (!(entryCoder instanceof KvCoder)) {
            throw new IllegalArgumentException("PCollection does not use a KvCoder");
        }
        KvCoder coder = (KvCoder)entryCoder;
        return coder.getValueCoder();
    }

    private <V> PCollection<KV<K, RawUnionValue>> makeUnionTable(int index, PCollection<KV<K, V>> pCollection, KvCoder<K, RawUnionValue> unionTableEncoder) {
        return ((PCollection)pCollection.apply("MakeUnionTable" + index, ParDo.of(new ConstructUnionTableFn(index)))).setCoder(unionTableEncoder);
    }

    private static class ConstructCoGbkResultFn<K>
    extends DoFn<KV<K, Iterable<RawUnionValue>>, KV<K, CoGbkResult>> {
        private final CoGbkResultSchema schema;

        public ConstructCoGbkResultFn(CoGbkResultSchema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            KV e = (KV)c.element();
            c.output(KV.of(e.getKey(), new CoGbkResult(this.schema, (Iterable)e.getValue())));
        }
    }

    private static class ConstructUnionTableFn<K, V>
    extends DoFn<KV<K, V>, KV<K, RawUnionValue>> {
        private final int index;

        public ConstructUnionTableFn(int index) {
            this.index = index;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            KV e = (KV)c.element();
            c.output(KV.of(e.getKey(), new RawUnionValue(this.index, e.getValue())));
        }
    }
}

