/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.ConvertHelpers;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.AutoValue_DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoValue
@Internal
public abstract class DoFnSchemaInformation
implements Serializable {
    public abstract List<SerializableFunction<?, ?>> getElementConverters();

    public abstract FieldAccessDescriptor getFieldAccessDescriptor();

    public static DoFnSchemaInformation create() {
        return new AutoValue_DoFnSchemaInformation.Builder().setElementConverters(Collections.emptyList()).setFieldAccessDescriptor(FieldAccessDescriptor.create()).build();
    }

    public abstract Builder toBuilder();

    DoFnSchemaInformation withSelectFromSchemaParameter(SchemaCoder<?> inputCoder, FieldAccessDescriptor selectDescriptor, Schema selectOutputSchema, SchemaCoder<?> parameterCoder, boolean unbox) {
        ImmutableList converters = ImmutableList.builder().addAll(this.getElementConverters()).add((Object)ConversionFunction.of(inputCoder.getSchema(), inputCoder.getToRowFunction(), parameterCoder.getFromRowFunction(), selectDescriptor, unbox)).build();
        return this.toBuilder().setElementConverters((List<SerializableFunction<?, ?>>)converters).build();
    }

    DoFnSchemaInformation withUnboxPrimitiveParameter(SchemaCoder inputCoder, FieldAccessDescriptor selectDescriptor, Schema selectOutputSchema, TypeDescriptor<?> elementT) {
        if (selectOutputSchema.getFieldCount() != 1) {
            throw new RuntimeException("Parameter has no schema and the input is not a simple type.");
        }
        Schema.FieldType fieldType = selectOutputSchema.getField(0).getType();
        if (fieldType.getTypeName().isCompositeType()) {
            throw new RuntimeException("Parameter has no schema and the input is not a primitive type.");
        }
        ImmutableList converters = ImmutableList.builder().addAll(this.getElementConverters()).add((Object)UnboxingConversionFunction.of(inputCoder.getSchema(), inputCoder.getToRowFunction(), selectDescriptor, selectOutputSchema, elementT)).build();
        return this.toBuilder().setElementConverters((List<SerializableFunction<?, ?>>)converters).build();
    }

    DoFnSchemaInformation withFieldAccessDescriptor(FieldAccessDescriptor selectDescriptor) {
        FieldAccessDescriptor descriptor = FieldAccessDescriptor.union((Iterable<FieldAccessDescriptor>)ImmutableList.of((Object)this.getFieldAccessDescriptor(), (Object)selectDescriptor));
        return this.toBuilder().setFieldAccessDescriptor(descriptor).build();
    }

    private static class UnboxingConversionFunction<InputT, OutputT>
    implements SerializableFunction<InputT, OutputT> {
        private final SerializableFunction<InputT, Row> toRowFunction;
        private final Schema.FieldType primitiveType;
        private final TypeDescriptor<?> primitiveOutputType;
        private transient SerializableFunction<InputT, OutputT> conversionFunction;
        private final RowSelector rowSelector;

        private UnboxingConversionFunction(Schema inputSchema, SerializableFunction<InputT, Row> toRowFunction, FieldAccessDescriptor selectDescriptor, Schema selectOutputSchema, TypeDescriptor<?> primitiveOutputType) {
            this.toRowFunction = toRowFunction;
            this.primitiveType = selectOutputSchema.getField(0).getType();
            this.primitiveOutputType = primitiveOutputType;
            this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, selectDescriptor, true);
        }

        public static <InputT, OutputT> UnboxingConversionFunction of(Schema inputSchema, SerializableFunction<InputT, Row> toRowFunction, FieldAccessDescriptor selectDescriptor, Schema selectOutputSchema, TypeDescriptor<?> primitiveOutputType) {
            return new UnboxingConversionFunction<InputT, OutputT>(inputSchema, toRowFunction, selectDescriptor, selectOutputSchema, primitiveOutputType);
        }

        @Override
        public OutputT apply(InputT input) {
            Row row = this.toRowFunction.apply(input);
            Row selected = this.rowSelector.select(row);
            return this.getConversionFunction().apply(selected.getValue(0));
        }

        private SerializableFunction<InputT, OutputT> getConversionFunction() {
            if (this.conversionFunction == null) {
                this.conversionFunction = ConvertHelpers.getConvertPrimitive(this.primitiveType, this.primitiveOutputType, new ByteBuddyUtils.DefaultTypeConversionsFactory());
            }
            return this.conversionFunction;
        }
    }

    private static class ConversionFunction<InputT, OutputT>
    implements SerializableFunction<InputT, OutputT> {
        private final SerializableFunction<InputT, Row> toRowFunction;
        private final SerializableFunction<Row, OutputT> fromRowFunction;
        private final boolean unbox;
        private final RowSelector rowSelector;

        private ConversionFunction(Schema inputSchema, SerializableFunction<InputT, Row> toRowFunction, SerializableFunction<Row, OutputT> fromRowFunction, FieldAccessDescriptor selectDescriptor, boolean unbox) {
            this.toRowFunction = toRowFunction;
            this.fromRowFunction = fromRowFunction;
            this.unbox = unbox;
            this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, selectDescriptor, true);
        }

        public static <InputT, OutputT> ConversionFunction of(Schema inputSchema, SerializableFunction<InputT, Row> toRowFunction, SerializableFunction<Row, OutputT> fromRowFunction, FieldAccessDescriptor selectDescriptor, boolean unbox) {
            return new ConversionFunction<InputT, OutputT>(inputSchema, toRowFunction, fromRowFunction, selectDescriptor, unbox);
        }

        @Override
        public OutputT apply(InputT input) {
            Row row = this.toRowFunction.apply(input);
            Row selected = this.rowSelector.select(row);
            if (this.unbox) {
                selected = selected.getRow(0);
            }
            return this.fromRowFunction.apply(selected);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setElementConverters(List<SerializableFunction<?, ?>> var1);

        abstract Builder setFieldAccessDescriptor(FieldAccessDescriptor var1);

        abstract DoFnSchemaInformation build();
    }
}

