/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.lang.reflect.Method;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class FormInput<C extends Control> {
    public static final String vc_id = "$Id: FormInput.java 1672 2009-05-20 20:12:26Z robert $";
    protected Label label = null;
    protected C input = null;
    protected FormData labelFD = new FormData();
    protected FormData inputFD = new FormData();

    public FormInput(Label label, C input) {
        this.setLabel(label);
        this.setInput(input);
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
        this.label.setLayoutData((Object)this.getLabelFD());
    }

    public C getInput() {
        return this.input;
    }

    public void setInput(C input) {
        this.input = input;
        this.input.setLayoutData((Object)this.getInputFD());
    }

    public FormData getLabelFD() {
        return this.labelFD;
    }

    public void setLabelFD(FormData labelFD) {
        this.labelFD = labelFD;
    }

    public FormData getInputFD() {
        return this.inputFD;
    }

    public void setInputFD(FormData inputFD) {
        this.inputFD = inputFD;
    }

    public void setPosition(int numerator, int offset, Widget widget, Position side) {
        this.setPosition(new FormAttachment(numerator, offset), widget, side);
    }

    public void setPosition(Control control, int offset, Widget widget, Position side) {
        this.setPosition(new FormAttachment(control, offset), widget, side);
    }

    public void setPosition(FormAttachment position, Widget widget, Position side) {
        FormData layout = widget == Widget.LABEL ? this.getLabelFD() : this.getInputFD();
        switch (side) {
            case LEFT: {
                layout.left = position;
                break;
            }
            case RIGHT: {
                layout.right = position;
                break;
            }
            case TOP: {
                layout.top = position;
                break;
            }
            case BOTTOM: {
                layout.bottom = position;
                break;
            }
        }
    }

    public void setText(String text, Widget widget) {
        Object control = widget == Widget.LABEL ? this.getLabel() : this.getInput();
        Class[] params = new Class[]{String.class};
        try {
            Method method = control.getClass().getDeclaredMethod("setText", params);
            method.invoke(control, text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getText(Widget widget) {
        String text = null;
        Object control = widget == Widget.LABEL ? this.getLabel() : this.getInput();
        try {
            Method method = control.getClass().getDeclaredMethod("getText", new Class[0]);
            text = (String)method.invoke(control, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public void setToolTip(String text, Widget widget) {
        switch (widget) {
            case LABEL: {
                this.getLabel().setToolTipText(text);
                break;
            }
            case INPUT: {
                this.getInput().setToolTipText(text);
                break;
            }
        }
    }

    public static enum Widget {
        LABEL,
        INPUT;

    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

