/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTFCoverLetter;
import com.ibm.as400.access.PTFExitProgram;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PTF {
    private AS400 system_;
    private String productID_;
    private String returnedProductID_;
    private boolean actionPending_;
    private String actionRequired_;
    private boolean hasCoverLetter_;
    private int iplAction_;
    private String iplRequired_;
    private String loadedStatus_;
    private String maximumLevel_;
    private String minimumLevel_;
    private boolean ptfOnOrder_;
    private String ptfProductLoad_;
    private String ptfProductOption_;
    private String ptfID_;
    private boolean isPTFReleased_;
    private String ptfReleaseLevel_;
    private String returnedReleaseLevel_;
    private boolean saveFileExists_;
    private Date statusDate_;
    private String currentIPLSource_;
    private String licGroup_;
    private String saveFile_;
    private String supersedingPTF_;
    private String targetRelease_;
    private int serverIPLRequired_ = -1;
    private String creationDateAndTime_;
    private String productStatus_;
    private String omitStatus_;
    private boolean loaded_ = false;
    private boolean partiallyLoaded_ = false;
    private boolean partiallyLoadedGroup_ = false;
    private boolean loaded200_ = false;
    private boolean loaded300_ = false;
    private boolean loaded500_ = false;
    private boolean loaded600_ = false;
    private boolean loaded700_ = false;
    private boolean loaded800_ = false;
    private int chunkSize_ = 8192;
    private PTFCoverLetter[] coverLetters_;
    private PTF[] requisites_;
    private boolean isPreRequisite_;
    private boolean isCoRequisite_;
    private boolean isConditional_;
    private boolean isRequired_;
    private PTF[] dependents_;
    private boolean isDependent_;
    private boolean loadedRequisites_ = false;
    private boolean loadedDependents_ = false;
    private String[] apars_;
    private String[] symptoms_;
    private PTFExitProgram[] exitPrograms_;
    private String messageData_;
    private int techRefreshPTF_;
    public static final String ACTION_NOT_REQUIRED = "0";
    public static final String ACTION_REQUIRED_EXIT_PROGRAM = "1";
    public static final String ACTION_REQUIRED_CANNOT_VERIFY = "2";
    public static final int IPL_ACTION_NONE = 0;
    public static final int IPL_ACTION_APPLY_TEMPORARY = 1;
    public static final int IPL_ACTION_REMOVE_TEMPORARY = 2;
    public static final int IPL_ACTION_APPLY_PERMANENT = 3;
    public static final int IPL_ACTION_REMOVE_PERMANENT = 4;
    public static final String IPL_SOURCE_A = "A";
    public static final String IPL_SOURCE_B = "B";
    public static final String IPL_SOURCE_UNKNOWN = " ";
    public static final String PRODUCT_ID_ONLY = "*ONLY";
    public static final String PRODUCT_RELEASE_ONLY = "*ONLY";
    public static final String PTF_TYPE_DELAYED = "0";
    public static final String PTF_TYPE_IMMEDIATE = "1";
    public static final String PTF_TYPE_UNKNOWN = " ";
    public static final String RELATIONSHIP_COREQ = "*COREQ";
    public static final String RELATIONSHIP_DEPEND = "*DEPEND";
    public static final String RELATIONSHIP_NONE = "*NONE";
    public static final String RELATIONSHIP_PREREQ = "*PREREQ";
    public static final String RELATIONSHIP_SAME = "*SAME";
    public static final String STATUS_NOT_LOADED = "0";
    public static final String STATUS_LOADED = "1";
    public static final String STATUS_APPLIED = "2";
    public static final String STATUS_APPLIED_PERMANENT = "3";
    public static final String STATUS_REMOVED_PERMANENT = "4";
    public static final String STATUS_DAMAGED = "5";
    public static final String STATUS_SUPERSEDED = "6";
    private static int baseSize_ = 115;

    public PTF(AS400 aS400, String string) {
        this(aS400, string, "*ONLY", "*ONLY");
    }

    public PTF(AS400 aS400, String string, String string2, String string3) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("ptfID");
        }
        if (string2 == null) {
            throw new NullPointerException("productID");
        }
        if (string3 == null) {
            throw new NullPointerException("releaseLevel");
        }
        this.system_ = aS400;
        String string4 = string.toUpperCase().trim();
        if (string4.length() != 7) {
            throw new ExtendedIllegalArgumentException("ptfID (" + string + ")", 1);
        }
        String string5 = string2.toUpperCase().trim();
        if (string5.length() != 7 && !string5.equals("*ONLY")) {
            throw new ExtendedIllegalArgumentException("productID (" + string2 + ")", 1);
        }
        String string6 = string3.toUpperCase().trim();
        if (!string5.equals("*ONLY") && string6.length() != 6) {
            throw new ExtendedIllegalArgumentException("releaseLevel (" + string3 + ")", 1);
        }
        this.ptfID_ = string4;
        this.productID_ = string5;
        this.ptfReleaseLevel_ = string6;
    }

    PTF(AS400 aS400, String string, String string2, String string3, String string4, String string5) {
        this.system_ = aS400;
        this.productID_ = string;
        this.ptfID_ = string2;
        this.ptfReleaseLevel_ = string3;
        this.ptfProductOption_ = string4;
        this.ptfProductLoad_ = string5;
    }

    PTF(AS400 aS400, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this(aS400, string, string2, string3, string4, string5);
        this.minimumLevel_ = string6;
        this.maximumLevel_ = string7;
        this.isDependent_ = bl;
        this.isCoRequisite_ = !bl;
        this.loadedDependents_ = true;
    }

    PTF(AS400 aS400, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3) {
        this(aS400, string, string2, string3, string4, string5);
        this.minimumLevel_ = string6;
        this.maximumLevel_ = string7;
        this.isPreRequisite_ = bl;
        this.isCoRequisite_ = !bl;
        this.isConditional_ = bl2;
        this.isRequired_ = bl3;
        this.loadedRequisites_ = true;
    }

    PTF(AS400 aS400, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, String string7, String string8, boolean bl5, String string9, String string10, Date date) {
        this(aS400, string, string2, string3, string4, string5);
        this.loadedStatus_ = string6;
        this.saveFileExists_ = bl;
        this.hasCoverLetter_ = bl2;
        this.ptfOnOrder_ = bl3;
        this.iplAction_ = n;
        this.actionPending_ = bl4;
        this.actionRequired_ = string7;
        this.iplRequired_ = string8;
        this.isPTFReleased_ = bl5;
        this.minimumLevel_ = string9;
        this.maximumLevel_ = string10;
        this.statusDate_ = date;
        this.partiallyLoaded_ = true;
    }

    PTF(AS400 aS400, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19) {
        this(aS400, string2, string, string3, string4, string5);
        this.returnedProductID_ = string2;
        this.returnedReleaseLevel_ = string3;
        this.loadedStatus_ = string8;
        this.saveFileExists_ = !string13.equals("0");
        this.hasCoverLetter_ = !string11.equals("0");
        this.ptfOnOrder_ = !string12.equals("0");
        this.iplAction_ = n;
        this.actionPending_ = !string9.equals("0");
        this.actionRequired_ = string10;
        this.minimumLevel_ = string6;
        this.maximumLevel_ = string7;
        this.saveFile_ = string14;
        this.supersedingPTF_ = string16;
        this.productStatus_ = string18;
        this.omitStatus_ = string19;
        this.partiallyLoadedGroup_ = true;
    }

    public String getProductStatus() {
        if (!this.partiallyLoadedGroup_) {
            return "";
        }
        return this.productStatus_;
    }

    public String getOmitStatus() {
        if (!this.partiallyLoadedGroup_) {
            return "";
        }
        return this.omitStatus_;
    }

    public String getActionRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.actionRequired_;
    }

    public String[] getAPARNumbers() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded600_) {
            this.refresh(600);
        }
        return this.apars_;
    }

    public PTFCoverLetter getCoverLetter() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getCoverLetter(this.system_.getLocale());
    }

    public PTFCoverLetter getCoverLetter(Locale locale) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        PTFCoverLetter[] pTFCoverLetterArray = this.getCoverLetters();
        if (pTFCoverLetterArray.length > 0) {
            String string = ExecutionEnvironment.getNlv(locale);
            for (int i = 0; i < pTFCoverLetterArray.length; ++i) {
                if (!pTFCoverLetterArray[i].getNLV().equals(string)) continue;
                return pTFCoverLetterArray[i];
            }
            return pTFCoverLetterArray[0];
        }
        return null;
    }

    public PTFCoverLetter[] getCoverLetters() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.hasCoverLetter()) {
            if (!this.loaded200_) {
                this.refresh(200);
            }
            return this.coverLetters_;
        }
        return new PTFCoverLetter[0];
    }

    public String getCurrentIPLSource() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.currentIPLSource_;
    }

    public PTF[] getDependentPTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.dependents_;
    }

    public PTFExitProgram[] getExitPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded800_) {
            this.refresh(800);
        }
        return this.exitPrograms_;
    }

    public String getID() {
        return this.ptfID_;
    }

    public int getIPLAction() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.iplAction_;
    }

    public String getIPLRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.iplRequired_;
    }

    public String getLICGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.licGroup_;
    }

    public String getLoadedStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.loadedStatus_;
    }

    public String getLoadedStatusMessage(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.messageData_ == null) {
            try {
                MessageFile messageFile = new MessageFile(this.system_, "/QSYS.LIB/QCPFMSG.MSGF");
                AS400Message aS400Message = messageFile.getMessage("CPX3501");
                if (aS400Message != null) {
                    this.messageData_ = aS400Message.getHelp();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (string.equals("0")) {
            return this.messageData_.substring(0, 11).trim();
        }
        if (string.equals(STATUS_DAMAGED)) {
            return this.messageData_.substring(11, 27).trim();
        }
        if (string.equals(STATUS_SUPERSEDED)) {
            return this.messageData_.substring(27, 47).trim();
        }
        if (string.equals("2")) {
            return this.messageData_.substring(47, 82).trim();
        }
        if (string.equals(STATUS_APPLIED_PERMANENT)) {
            return this.messageData_.substring(104, 139).trim();
        }
        if (string.equals("1")) {
            return this.messageData_.substring(82, 104).trim();
        }
        if (string.equals(STATUS_REMOVED_PERMANENT)) {
            return this.messageData_.substring(567, 602).trim();
        }
        return "";
    }

    public String getMaximumLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.maximumLevel_;
    }

    public String getMinimumLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.minimumLevel_;
    }

    public String getProductFeature() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.ptfProductLoad_;
    }

    public String getProductID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.returnedProductID_ == null) {
            this.refresh(100);
        }
        return this.returnedProductID_;
    }

    public String getProductOption() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.ptfProductOption_;
    }

    public String getRelationship(PTF pTF) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        String string;
        String string2 = this.getID();
        if (string2.equals(string = pTF.getID())) {
            return RELATIONSHIP_SAME;
        }
        this.refresh(300);
        this.refresh(500);
        pTF.refresh(300);
        pTF.refresh(500);
        PTF[] pTFArray = this.getRequisitePTFs();
        PTF[] pTFArray2 = this.getDependentPTFs();
        PTF[] pTFArray3 = pTF.getRequisitePTFs();
        PTF[] pTFArray4 = pTF.getDependentPTFs();
        for (n = 0; n < pTFArray.length; ++n) {
            if (!pTFArray[n].getID().equals(string)) continue;
            if (pTFArray[n].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_DEPEND;
        }
        for (n = 0; n < pTFArray2.length; ++n) {
            if (!pTFArray2[n].getID().equals(string)) continue;
            if (pTFArray2[n].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_PREREQ;
        }
        for (n = 0; n < pTFArray3.length; ++n) {
            if (!pTFArray3[n].getID().equals(string2)) continue;
            if (pTFArray3[n].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_PREREQ;
        }
        for (n = 0; n < pTFArray4.length; ++n) {
            if (!pTFArray4[n].getID().equals(string2)) continue;
            if (pTFArray4[n].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_DEPEND;
        }
        return RELATIONSHIP_NONE;
    }

    public String getReleaseLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.returnedReleaseLevel_ == null) {
            this.refresh(100);
        }
        return this.returnedReleaseLevel_;
    }

    public PTF[] getRequisitePTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded300_) {
            this.refresh(300);
        }
        return this.requisites_;
    }

    public String getSaveFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.hasSaveFile()) {
            if (!this.loaded_ && !this.partiallyLoadedGroup_) {
                this.refresh(100);
            }
            return this.saveFile_;
        }
        return null;
    }

    public Date getStatusDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.statusDate_;
    }

    public String getSupersedingPTF() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoadedGroup_) {
            this.refresh(100);
        }
        return this.supersedingPTF_;
    }

    public String[] getSymptomStrings() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded700_) {
            this.refresh(700);
        }
        return this.symptoms_;
    }

    public String getTargetRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.targetRelease_;
    }

    public Date getCreationDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        TimeZone timeZone = DateTimeConverter.timeZoneForSystem(this.system_);
        Calendar calendar = AS400Calendar.getGregorianInstance(timeZone);
        calendar.clear();
        String string = this.creationDateAndTime_;
        if (string == null || string.length() == 0) {
            return null;
        }
        calendar.set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(7, 9)), Integer.parseInt(string.substring(9, 11)), Integer.parseInt(string.substring(11, 13)));
        return calendar.getTime();
    }

    public int getServerIPLRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.serverIPLRequired_;
    }

    boolean hasCoverLetter() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.hasCoverLetter_;
    }

    boolean hasSaveFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.saveFileExists_;
    }

    public boolean isActionPending() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.actionPending_;
    }

    public boolean isConditional() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isConditional_;
    }

    public boolean isCoRequisite() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loadedRequisites_ || this.loadedDependents_ || this.loaded300_)) {
            this.refresh(300);
            this.refresh(500);
        }
        return this.isCoRequisite_;
    }

    public boolean isDependent() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedDependents_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isDependent_;
    }

    public boolean isOnOrder() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.ptfOnOrder_;
    }

    public boolean isPreRequisite() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded500_) {
            this.refresh(500);
        }
        return this.isPreRequisite_;
    }

    public boolean isReleased() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.isPTFReleased_;
    }

    public boolean isRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isRequired_;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.refresh(200);
        this.refresh(300);
        this.refresh(500);
        this.refresh(600);
        this.refresh(700);
        this.refresh(800);
    }

    private void refresh(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        String string;
        int n2;
        String string2 = null;
        int n3 = 0;
        switch (n) {
            case 100: {
                string2 = "PTFR0100";
                n3 = 200;
                break;
            }
            case 200: {
                string2 = "PTFR0200";
                n3 = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 300: {
                string2 = "PTFR0300";
                n3 = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 500: {
                string2 = "PTFR0500";
                n3 = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 600: {
                string2 = "PTFR0600";
                n3 = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 700: {
                string2 = "PTFR0700";
                n3 = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 800: {
                string2 = "PTFR0800";
                n3 = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            default: {
                string2 = "PTFR0100";
                n3 = baseSize_ + this.chunkSize_;
            }
        }
        int n4 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n4, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        byte[] byArray = new byte[50];
        AS400Text aS400Text = new AS400Text(7, n4, this.system_);
        AS400Text aS400Text2 = new AS400Text(6, n4, this.system_);
        AS400Text aS400Text3 = new AS400Text(25, n4, this.system_);
        aS400Text.toBytes(this.ptfID_, byArray, 0);
        aS400Text.toBytes(this.productID_, byArray, 7);
        aS400Text2.toBytes(this.ptfReleaseLevel_, byArray, 14);
        byArray[24] = -16;
        aS400Text3.toBytes(" ", byArray, 25);
        programParameterArray[2] = new ProgramParameter(byArray);
        programParameterArray[3] = new ProgramParameter(convTable.stringToByteArray(string2));
        programParameterArray[4] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QPZRTVFX.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray2 = programParameterArray[0].getOutputData();
        int n5 = BinaryConverter.byteArrayToInt(byArray2, 0);
        if (n5 < (n2 = BinaryConverter.byteArrayToInt(byArray2, 4))) {
            this.chunkSize_ = n2;
            this.refresh(n);
            return;
        }
        this.returnedProductID_ = convTable.byteArrayToString(byArray2, 12, 7);
        this.returnedReleaseLevel_ = convTable.byteArrayToString(byArray2, 26, 6);
        this.ptfProductOption_ = convTable.byteArrayToString(byArray2, 32, 4);
        this.ptfProductLoad_ = convTable.byteArrayToString(byArray2, 36, 4);
        this.loadedStatus_ = convTable.byteArrayToString(byArray2, 40, 1);
        this.hasCoverLetter_ = byArray2[41] == -15;
        this.ptfOnOrder_ = byArray2[42] == -15;
        boolean bl = this.saveFileExists_ = byArray2[43] == -15;
        if (this.saveFileExists_) {
            string = convTable.byteArrayToString(byArray2, 44, 10).trim();
            object = convTable.byteArrayToString(byArray2, 54, 10).trim();
            this.saveFile_ = QSYSObjectPathName.toPath((String)object, string, "SAVF");
        } else {
            this.saveFile_ = "";
        }
        this.iplRequired_ = convTable.byteArrayToString(byArray2, 64, 1);
        this.iplAction_ = byArray2[65] & 0xF;
        this.actionPending_ = byArray2[66] == -15;
        this.actionRequired_ = convTable.byteArrayToString(byArray2, 67, 1);
        this.isPTFReleased_ = byArray2[68] == -15;
        this.targetRelease_ = convTable.byteArrayToString(byArray2, 69, 6);
        this.supersedingPTF_ = convTable.byteArrayToString(byArray2, 75, 7).trim();
        this.currentIPLSource_ = convTable.byteArrayToString(byArray2, 82, 1);
        this.minimumLevel_ = convTable.byteArrayToString(byArray2, 83, 2);
        this.maximumLevel_ = convTable.byteArrayToString(byArray2, 85, 2);
        string = convTable.byteArrayToString(byArray2, 88, 13);
        if (string.trim().length() == 13) {
            object = AS400Calendar.getGregorianInstance();
            ((Calendar)object).clear();
            ((Calendar)object).set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(7, 9)), Integer.parseInt(string.substring(9, 11)), Integer.parseInt(string.substring(11, 13)));
            this.statusDate_ = ((Calendar)object).getTime();
        } else {
            this.statusDate_ = null;
        }
        this.licGroup_ = convTable.byteArrayToString(byArray2, 101, 7).trim();
        if (byArray2.length >= 115 && byArray2.length >= 130) {
            this.serverIPLRequired_ = byArray2[116] & 0xF;
            this.creationDateAndTime_ = convTable.byteArrayToString(byArray2, 117, 13).trim();
            this.techRefreshPTF_ = byArray2[130] & 0xF;
        }
        this.loaded_ = true;
        if (n == 200) {
            int n6 = BinaryConverter.byteArrayToInt(byArray2, 8);
            int n7 = BinaryConverter.byteArrayToInt(byArray2, n6);
            int n8 = BinaryConverter.byteArrayToInt(byArray2, n6 += 4);
            int n9 = BinaryConverter.byteArrayToInt(byArray2, n6 += 4);
            this.coverLetters_ = new PTFCoverLetter[n8];
            for (int i = 0; i < n8; ++i) {
                n6 = n7 + i * n9;
                String string3 = convTable.byteArrayToString(byArray2, n6, 4);
                String string4 = convTable.byteArrayToString(byArray2, n6 += 4, 10).trim();
                String string5 = convTable.byteArrayToString(byArray2, n6 += 10, 10).trim();
                String string6 = convTable.byteArrayToString(byArray2, n6 += 10, 10).trim();
                n6 += 10;
                int n10 = byArray2[n6++] & 0xF;
                int n11 = byArray2[n6] & 0xF;
                String string7 = QSYSObjectPathName.toPath(string5, string4, string6, "MBR");
                this.coverLetters_[i] = new PTFCoverLetter(this.system_, string3, string7, n10, n11);
            }
            this.loaded200_ = true;
        } else if (n == 300) {
            int n12 = BinaryConverter.byteArrayToInt(byArray2, 8);
            int n13 = BinaryConverter.byteArrayToInt(byArray2, n12);
            int n14 = BinaryConverter.byteArrayToInt(byArray2, n12 += 4);
            int n15 = BinaryConverter.byteArrayToInt(byArray2, n12 += 4);
            this.requisites_ = new PTF[n14];
            for (int i = 0; i < n14; ++i) {
                byte by;
                n12 = n13 + i * n15;
                String string8 = convTable.byteArrayToString(byArray2, n12, 7);
                String string9 = convTable.byteArrayToString(byArray2, n12 += 7, 7);
                String string10 = convTable.byteArrayToString(byArray2, n12 += 7, 6);
                String string11 = convTable.byteArrayToString(byArray2, n12 += 6, 2);
                String string12 = convTable.byteArrayToString(byArray2, n12 += 2, 2);
                n12 += 2;
                boolean bl2 = (by = byArray2[n12++]) == -15;
                boolean bl3 = byArray2[n12++] == -15;
                boolean bl4 = byArray2[n12++] == -15;
                String string13 = convTable.byteArrayToString(byArray2, n12, 4);
                String string14 = convTable.byteArrayToString(byArray2, n12 += 4, 4);
                this.requisites_[i] = new PTF(this.system_, string8, string9, string10, string13, string14, string11, string12, bl2, bl3, bl4);
                if (bl2) {
                    this.isDependent_ = true;
                } else {
                    this.isCoRequisite_ = true;
                }
                if (!bl3) continue;
                this.isConditional_ = true;
            }
            this.loaded300_ = true;
        } else if (n == 500) {
            int n16 = BinaryConverter.byteArrayToInt(byArray2, 8);
            int n17 = BinaryConverter.byteArrayToInt(byArray2, n16);
            int n18 = BinaryConverter.byteArrayToInt(byArray2, n16 += 4);
            int n19 = BinaryConverter.byteArrayToInt(byArray2, n16 += 4);
            this.dependents_ = new PTF[n18];
            for (int i = 0; i < n18; ++i) {
                byte by;
                n16 = n17 + i * n19;
                String string15 = convTable.byteArrayToString(byArray2, n16, 7);
                String string16 = convTable.byteArrayToString(byArray2, n16 += 7, 7);
                String string17 = convTable.byteArrayToString(byArray2, n16 += 7, 6);
                String string18 = convTable.byteArrayToString(byArray2, n16 += 6, 2);
                String string19 = convTable.byteArrayToString(byArray2, n16 += 2, 2);
                n16 += 2;
                boolean bl5 = (by = byArray2[n16++]) == -15;
                String string20 = convTable.byteArrayToString(byArray2, n16, 4);
                String string21 = convTable.byteArrayToString(byArray2, n16 += 4, 4);
                this.dependents_[i] = new PTF(this.system_, string15, string16, string17, string20, string21, string18, string19, bl5);
                if (bl5) {
                    this.isPreRequisite_ = true;
                    continue;
                }
                this.isCoRequisite_ = true;
            }
            this.loaded500_ = true;
        } else if (n == 600) {
            int n20 = BinaryConverter.byteArrayToInt(byArray2, 8);
            int n21 = BinaryConverter.byteArrayToInt(byArray2, n20);
            int n22 = BinaryConverter.byteArrayToInt(byArray2, n20 += 4);
            int n23 = BinaryConverter.byteArrayToInt(byArray2, n20 += 4);
            this.apars_ = new String[n22];
            for (int i = 0; i < n22; ++i) {
                n20 = n21 + i * n23;
                this.apars_[i] = convTable.byteArrayToString(byArray2, n20, 7);
            }
            this.loaded600_ = true;
        } else if (n == 700) {
            int n24 = BinaryConverter.byteArrayToInt(byArray2, 8);
            int n25 = BinaryConverter.byteArrayToInt(byArray2, n24);
            int n26 = BinaryConverter.byteArrayToInt(byArray2, n24 += 4);
            int n27 = BinaryConverter.byteArrayToInt(byArray2, n24 += 4);
            this.symptoms_ = new String[n26];
            for (int i = 0; i < n26; ++i) {
                n24 = n25 + i * n27;
                int n28 = BinaryConverter.byteArrayToInt(byArray2, n24);
                int n29 = BinaryConverter.byteArrayToInt(byArray2, n24 += 4);
                this.symptoms_[i] = convTable.byteArrayToString(byArray2, n28, n29);
            }
            this.loaded700_ = true;
        } else if (n == 800) {
            int n30 = BinaryConverter.byteArrayToInt(byArray2, 8);
            int n31 = BinaryConverter.byteArrayToInt(byArray2, n30);
            int n32 = BinaryConverter.byteArrayToInt(byArray2, n30 += 4);
            int n33 = BinaryConverter.byteArrayToInt(byArray2, n30 += 4);
            this.exitPrograms_ = new PTFExitProgram[n32];
            for (int i = 0; i < n32; ++i) {
                n30 = n31 + i * n33;
                int n34 = BinaryConverter.byteArrayToInt(byArray2, n30);
                int n35 = BinaryConverter.byteArrayToInt(byArray2, n30 += 4);
                String string22 = convTable.byteArrayToString(byArray2, n30 += 4, 10).trim();
                String string23 = convTable.byteArrayToString(byArray2, n30 += 10, 10).trim();
                String string24 = QSYSObjectPathName.toPath(string23, string22, "PGM");
                String string25 = convTable.byteArrayToString(byArray2, n30 += 10, 1);
                String string26 = convTable.byteArrayToString(byArray2, n34, n35);
                this.exitPrograms_[i] = new PTFExitProgram(string24, string25, string26);
            }
            this.loaded800_ = true;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.ptfID_);
        stringBuffer.append('/');
        stringBuffer.append(this.ptfReleaseLevel_);
        stringBuffer.append('/');
        stringBuffer.append(this.productID_);
        return stringBuffer.toString();
    }

    public boolean getTechRefreshPTF() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.techRefreshPTF_ != 0;
    }
}

