/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.AbstractLauncher;
import org.apache.spark.launcher.ChildProcAppHandle;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.LauncherServer;
import org.apache.spark.launcher.NamedThreadFactory;
import org.apache.spark.launcher.OutputRedirector;
import org.apache.spark.launcher.SparkAppHandle;

public class SparkLauncher
extends AbstractLauncher<SparkLauncher> {
    private static final Logger LOG = Logger.getLogger(SparkLauncher.class.getName());
    public static final String SPARK_MASTER = "spark.master";
    public static final String DEPLOY_MODE = "spark.submit.deployMode";
    public static final String DRIVER_MEMORY = "spark.driver.memory";
    public static final String DRIVER_EXTRA_CLASSPATH = "spark.driver.extraClassPath";
    public static final String DRIVER_DEFAULT_JAVA_OPTIONS = "spark.driver.defaultJavaOptions";
    public static final String DRIVER_EXTRA_JAVA_OPTIONS = "spark.driver.extraJavaOptions";
    public static final String DRIVER_EXTRA_LIBRARY_PATH = "spark.driver.extraLibraryPath";
    public static final String EXECUTOR_MEMORY = "spark.executor.memory";
    public static final String EXECUTOR_EXTRA_CLASSPATH = "spark.executor.extraClassPath";
    public static final String EXECUTOR_DEFAULT_JAVA_OPTIONS = "spark.executor.defaultJavaOptions";
    public static final String EXECUTOR_EXTRA_JAVA_OPTIONS = "spark.executor.extraJavaOptions";
    public static final String EXECUTOR_EXTRA_LIBRARY_PATH = "spark.executor.extraLibraryPath";
    public static final String EXECUTOR_CORES = "spark.executor.cores";
    static final String PYSPARK_DRIVER_PYTHON = "spark.pyspark.driver.python";
    static final String PYSPARK_PYTHON = "spark.pyspark.python";
    static final String SPARKR_R_SHELL = "spark.r.shell.command";
    public static final String CHILD_PROCESS_LOGGER_NAME = "spark.launcher.childProcLoggerName";
    public static final String NO_RESOURCE = "spark-internal";
    public static final String DEPRECATED_CHILD_CONNECTION_TIMEOUT = "spark.launcher.childConectionTimeout";
    public static final String CHILD_CONNECTION_TIMEOUT = "spark.launcher.childConnectionTimeout";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    static final ThreadFactory REDIRECTOR_FACTORY = new NamedThreadFactory("launcher-proc-%d");
    static final Map<String, String> launcherConfig = new HashMap<String, String>();
    File workingDir;
    boolean redirectErrorStream;
    ProcessBuilder.Redirect errorStream;
    ProcessBuilder.Redirect outputStream;

    public static void setConfig(String name, String value) {
        launcherConfig.put(name, value);
    }

    public SparkLauncher() {
        this(null);
    }

    public SparkLauncher(Map<String, String> env) {
        if (env != null) {
            this.builder.childEnv.putAll(env);
        }
    }

    public SparkLauncher setJavaHome(String javaHome) {
        CommandBuilderUtils.checkNotNull(javaHome, "javaHome");
        this.builder.javaHome = javaHome;
        return this;
    }

    public SparkLauncher setSparkHome(String sparkHome) {
        CommandBuilderUtils.checkNotNull(sparkHome, "sparkHome");
        this.builder.childEnv.put("SPARK_HOME", sparkHome);
        return this;
    }

    public SparkLauncher directory(File dir) {
        this.workingDir = dir;
        return this;
    }

    public SparkLauncher redirectError() {
        this.redirectErrorStream = true;
        return this;
    }

    public SparkLauncher redirectError(ProcessBuilder.Redirect to) {
        this.errorStream = to;
        return this;
    }

    public SparkLauncher redirectOutput(ProcessBuilder.Redirect to) {
        this.outputStream = to;
        return this;
    }

    public SparkLauncher redirectError(File errFile) {
        this.errorStream = ProcessBuilder.Redirect.to(errFile);
        return this;
    }

    public SparkLauncher redirectOutput(File outFile) {
        this.outputStream = ProcessBuilder.Redirect.to(outFile);
        return this;
    }

    public SparkLauncher redirectToLog(String loggerName) {
        this.setConf(CHILD_PROCESS_LOGGER_NAME, loggerName);
        return this;
    }

    @Override
    public SparkLauncher setPropertiesFile(String path) {
        return (SparkLauncher)super.setPropertiesFile(path);
    }

    @Override
    public SparkLauncher setConf(String key, String value) {
        return (SparkLauncher)super.setConf(key, value);
    }

    @Override
    public SparkLauncher setAppName(String appName) {
        return (SparkLauncher)super.setAppName(appName);
    }

    @Override
    public SparkLauncher setMaster(String master) {
        return (SparkLauncher)super.setMaster(master);
    }

    @Override
    public SparkLauncher setDeployMode(String mode) {
        return (SparkLauncher)super.setDeployMode(mode);
    }

    @Override
    public SparkLauncher setAppResource(String resource) {
        return (SparkLauncher)super.setAppResource(resource);
    }

    @Override
    public SparkLauncher setMainClass(String mainClass) {
        return (SparkLauncher)super.setMainClass(mainClass);
    }

    @Override
    public SparkLauncher addSparkArg(String arg) {
        return (SparkLauncher)super.addSparkArg(arg);
    }

    @Override
    public SparkLauncher addSparkArg(String name, String value) {
        return (SparkLauncher)super.addSparkArg(name, value);
    }

    @Override
    public SparkLauncher addAppArgs(String ... args) {
        return (SparkLauncher)super.addAppArgs(args);
    }

    @Override
    public SparkLauncher addJar(String jar) {
        return (SparkLauncher)super.addJar(jar);
    }

    @Override
    public SparkLauncher addFile(String file) {
        return (SparkLauncher)super.addFile(file);
    }

    @Override
    public SparkLauncher addPyFile(String file) {
        return (SparkLauncher)super.addPyFile(file);
    }

    @Override
    public SparkLauncher setVerbose(boolean verbose) {
        return (SparkLauncher)super.setVerbose(verbose);
    }

    public Process launch() throws IOException {
        ProcessBuilder pb = this.createBuilder();
        boolean outputToLog = this.outputStream == null;
        boolean errorToLog = !this.redirectErrorStream && this.errorStream == null;
        String loggerName = this.getLoggerName();
        if (loggerName != null && outputToLog && errorToLog) {
            pb.redirectErrorStream(true);
        }
        Process childProc = pb.start();
        if (loggerName != null) {
            InputStream logStream = outputToLog ? childProc.getInputStream() : childProc.getErrorStream();
            new OutputRedirector(logStream, loggerName, REDIRECTOR_FACTORY);
        }
        return childProc;
    }

    @Override
    public SparkAppHandle startApplication(SparkAppHandle.Listener ... listeners) throws IOException {
        boolean errorToLog;
        LauncherServer server = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server);
        for (SparkAppHandle.Listener l : listeners) {
            handle.addListener(l);
        }
        String secret = server.registerHandle(handle);
        String loggerName = this.getLoggerName();
        ProcessBuilder pb = this.createBuilder();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Launching Spark application:%n%s", CommandBuilderUtils.join(" ", pb.command())));
        }
        boolean outputToLog = this.outputStream == null;
        boolean bl = errorToLog = !this.redirectErrorStream && this.errorStream == null;
        if (loggerName == null && (outputToLog || errorToLog)) {
            int dot;
            String appName = this.builder.appName != null ? this.builder.appName : (this.builder.mainClass != null ? ((dot = this.builder.mainClass.lastIndexOf(".")) >= 0 && dot < this.builder.mainClass.length() - 1 ? this.builder.mainClass.substring(dot + 1, this.builder.mainClass.length()) : this.builder.mainClass) : (this.builder.appResource != null ? new File(this.builder.appResource).getName() : String.valueOf(COUNTER.incrementAndGet())));
            String loggerPrefix = this.getClass().getPackage().getName();
            loggerName = String.format("%s.app.%s", loggerPrefix, appName);
        }
        if (outputToLog && errorToLog) {
            pb.redirectErrorStream(true);
        }
        pb.environment().put("_SPARK_LAUNCHER_PORT", String.valueOf(server.getPort()));
        pb.environment().put("_SPARK_LAUNCHER_SECRET", secret);
        try {
            Process child = pb.start();
            InputStream logStream = null;
            if (loggerName != null) {
                logStream = outputToLog ? child.getInputStream() : child.getErrorStream();
            }
            handle.setChildProc(child, loggerName, logStream);
        }
        catch (IOException ioe) {
            handle.kill();
            throw ioe;
        }
        return handle;
    }

    private ProcessBuilder createBuilder() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.findSparkSubmit());
        cmd.addAll(this.builder.buildSparkSubmitArgs());
        if (CommandBuilderUtils.isWindows()) {
            ArrayList<String> winCmd = new ArrayList<String>();
            for (String string : cmd) {
                winCmd.add(CommandBuilderUtils.quoteForBatchScript(string));
            }
            cmd = winCmd;
        }
        ProcessBuilder pb = new ProcessBuilder(cmd.toArray(new String[cmd.size()]));
        for (Map.Entry entry : this.builder.childEnv.entrySet()) {
            pb.environment().put((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.workingDir != null) {
            pb.directory(this.workingDir);
        }
        CommandBuilderUtils.checkState(!this.redirectErrorStream || this.errorStream == null, "Cannot specify both redirectError() and redirectError(...) ", new Object[0]);
        CommandBuilderUtils.checkState(this.getLoggerName() == null || !this.redirectErrorStream && this.errorStream == null || this.outputStream == null, "Cannot used redirectToLog() in conjunction with other redirection methods.", new Object[0]);
        if (this.redirectErrorStream) {
            pb.redirectErrorStream(true);
        }
        if (this.errorStream != null) {
            pb.redirectError(this.errorStream);
        }
        if (this.outputStream != null) {
            pb.redirectOutput(this.outputStream);
        }
        return pb;
    }

    @Override
    SparkLauncher self() {
        return this;
    }

    String findSparkSubmit() {
        String script = CommandBuilderUtils.isWindows() ? "spark-submit.cmd" : "spark-submit";
        return CommandBuilderUtils.join(File.separator, this.builder.getSparkHome(), "bin", script);
    }

    private String getLoggerName() throws IOException {
        return this.builder.getEffectiveConfig().get(CHILD_PROCESS_LOGGER_NAME);
    }
}

