/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.svg;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hop.core.exception.HopException;
import org.w3c.dom.Document;

public class SvgImage {
    private final Document document;

    public SvgImage(Document doc) {
        this.document = doc;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getSvgXml() throws HopException {
        return SvgImage.getSvgXml(this.document);
    }

    public static final String getSvgXml(Document document) throws HopException {
        try {
            DOMSource domSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(domSource, streamResult);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new HopException("Error serializing SVG Image to SVG XML", e);
        }
    }
}

