/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.fileexists;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="FILE_EXISTS", name="i18n::ActionFileExists.Name", description="i18n::ActionFileExists.Description", image="FileExists.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionFileExists.keyword"}, documentationUrl="/workflow/actions/fileexists.html")
public class ActionFileExists
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionFileExists.class;
    private String filename = null;

    public ActionFileExists(String n) {
        super(n, "");
    }

    public ActionFileExists() {
        this("");
    }

    public Object clone() {
        ActionFileExists je = (ActionFileExists)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(20);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionFileExists.ERROR_0001_Cannot_Load_Workflow_Action_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public Result execute(Result previousResult, int nr) {
        Result result;
        block5: {
            result = previousResult;
            result.setResult(false);
            result.setNrErrors(0L);
            if (this.filename != null) {
                String realFilename = this.getRealFilename();
                try {
                    FileObject file = HopVfs.getFileObject((String)realFilename);
                    if (file.exists() && file.isReadable()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFileExists.File_Exists", (String[])new String[]{realFilename}));
                        result.setResult(true);
                        break block5;
                    }
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFileExists.File_Does_Not_Exist", (String[])new String[]{realFilename}));
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFileExists.ERROR_0004_IO_Exception", (String[])new String[]{e.getMessage()}), e);
                }
            } else {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"ActionFileExists.ERROR_0005_No_Filename_Defined", (String[])new String[0]));
            }
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = this.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject;
            if (!Utils.isEmpty((CharSequence)this.filename) && (fileObject = HopVfs.getFileObject((String)variables.resolve(this.filename))).exists()) {
                this.filename = namingInterface.nameResource(fileObject, variables, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

