/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class TimestampRange
implements Serializable {
    private static final long serialVersionUID = -3597929310338724839L;
    private final Timestamp from;
    private final Timestamp to;

    public static TimestampRange of(Timestamp from, Timestamp to) {
        return new TimestampRange(from, to);
    }

    @VisibleForTesting
    TimestampRange(Timestamp from, Timestamp to) {
        Preconditions.checkArgument((from.compareTo(to) <= 0 ? 1 : 0) != 0, (String)"Malformed range [%s, %s)", (Object)from, (Object)to);
        this.from = from;
        this.to = to;
    }

    public Timestamp getFrom() {
        return this.from;
    }

    public Timestamp getTo() {
        return this.to;
    }

    public String toString() {
        return "[" + this.from + ", " + this.to + ')';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimestampRange)) {
            return false;
        }
        TimestampRange that = (TimestampRange)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

