/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import java.util.Random;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

class AdaptiveThrottler {
    private final MovingFunction successfulRequests;
    private final MovingFunction allRequests;
    private final double overloadRatio;
    private static final double MIN_REQUESTS = 1.0;
    private final Random random;

    public AdaptiveThrottler(long samplePeriodMs, long sampleUpdateMs, double overloadRatio) {
        this(samplePeriodMs, sampleUpdateMs, overloadRatio, new Random());
    }

    @VisibleForTesting
    AdaptiveThrottler(long samplePeriodMs, long sampleUpdateMs, double overloadRatio, Random random) {
        this.allRequests = new MovingFunction(samplePeriodMs, sampleUpdateMs, 1, 1, Sum.ofLongs());
        this.successfulRequests = new MovingFunction(samplePeriodMs, sampleUpdateMs, 1, 1, Sum.ofLongs());
        this.overloadRatio = overloadRatio;
        this.random = random;
    }

    @VisibleForTesting
    double throttlingProbability(long nowMsSinceEpoch) {
        if (!this.allRequests.isSignificant()) {
            return 0.0;
        }
        long allRequestsNow = this.allRequests.get(nowMsSinceEpoch);
        long successfulRequestsNow = this.successfulRequests.get(nowMsSinceEpoch);
        return Math.max(0.0, ((double)allRequestsNow - this.overloadRatio * (double)successfulRequestsNow) / ((double)allRequestsNow + 1.0));
    }

    public boolean throttleRequest(long nowMsSinceEpoch) {
        double delayProbability = this.throttlingProbability(nowMsSinceEpoch);
        this.allRequests.add(nowMsSinceEpoch, 1L);
        return this.random.nextDouble() < delayProbability;
    }

    public void successfulRequest(long nowMsSinceEpoch) {
        this.successfulRequests.add(nowMsSinceEpoch, 1L);
    }
}

