/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQuerySourceBase<T>
extends BoundedSource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySourceBase.class);
    protected static final int JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    protected final String stepUuid;
    protected final BigQueryServices bqServices;
    private transient @Nullable List<BoundedSource<T>> cachedSplitResult = null;
    private SerializableFunction<TableSchema, AvroSource.DatumReaderFactory<T>> readerFactory;
    private Coder<T> coder;
    private final boolean useAvroLogicalTypes;

    BigQuerySourceBase(String stepUuid, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<TableSchema, AvroSource.DatumReaderFactory<T>> readerFactory, boolean useAvroLogicalTypes) {
        this.stepUuid = (String)Preconditions.checkArgumentNotNull((Object)stepUuid, (Object)"stepUuid");
        this.bqServices = (BigQueryServices)Preconditions.checkArgumentNotNull((Object)bqServices, (Object)"bqServices");
        this.coder = (Coder)Preconditions.checkArgumentNotNull(coder, (Object)"coder");
        this.readerFactory = (SerializableFunction)Preconditions.checkArgumentNotNull(readerFactory, (Object)"readerFactory");
        this.useAvroLogicalTypes = useAvroLogicalTypes;
    }

    protected ExtractResult extractFiles(PipelineOptions options) throws Exception {
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        TableReference tableToExtract = this.getTableToExtract(bqOptions);
        try (BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);){
            Table table = datasetService.getTable(tableToExtract);
            if (table == null) {
                throw new IOException(String.format("Cannot start an export job since table %s does not exist", BigQueryHelpers.toTableSpec(tableToExtract)));
            }
            TableSchema schema = table.getSchema();
            BigQueryServices.JobService jobService = this.bqServices.getJobService(bqOptions);
            String extractJobId = BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), this.stepUuid, BigQueryResourceNaming.JobType.EXPORT);
            String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", this.stepUuid);
            String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, tableToExtract.getProjectId(), tableToExtract.getDatasetId());
            List<ResourceId> tempFiles = this.executeExtract(extractJobId, tableToExtract, jobService, bqOptions.getProject(), extractDestinationDir, bqLocation, this.useAvroLogicalTypes);
            ExtractResult extractResult = new ExtractResult(schema, tempFiles);
            return extractResult;
        }
    }

    public List<BoundedSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        if (this.cachedSplitResult == null) {
            BigQueryOptions bqOptions;
            String extractDestinationDir;
            List matches;
            ExtractResult res = this.extractFiles(options);
            LOG.info("Extract job produced {} files", (Object)res.extractedFiles.size());
            if (res.extractedFiles.size() > 0 && (matches = FileSystems.match((List)ImmutableList.of((Object)((extractDestinationDir = BigQueryHelpers.resolveTempLocation((bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class)).getTempLocation(), "BigQueryExtractTemp", this.stepUuid)) + "*")))).size() > 0) {
                res.metadata = ((MatchResult)matches.get(0)).metadata();
            }
            this.cleanupTempResource((BigQueryOptions)options.as(BigQueryOptions.class));
            this.cachedSplitResult = this.createSources(res.extractedFiles, res.schema, res.metadata);
        }
        return this.cachedSplitResult;
    }

    protected abstract TableReference getTableToExtract(BigQueryOptions var1) throws Exception;

    protected abstract void cleanupTempResource(BigQueryOptions var1) throws Exception;

    public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
        throw new UnsupportedOperationException("BigQuery source must be split before being read");
    }

    public void validate() {
    }

    public Coder<T> getOutputCoder() {
        return this.coder;
    }

    private List<ResourceId> executeExtract(String jobId, TableReference table, BigQueryServices.JobService jobService, String executingProject, String extractDestinationDir, String bqLocation, boolean useAvroLogicalTypes) throws InterruptedException, IOException {
        Job extractJob;
        JobReference jobRef = new JobReference().setProjectId(executingProject).setLocation(bqLocation).setJobId(jobId);
        String destinationUri = BigQueryIO.getExtractDestinationUri(extractDestinationDir);
        JobConfigurationExtract extract = new JobConfigurationExtract().setSourceTable(table).setDestinationFormat("AVRO").setUseAvroLogicalTypes(Boolean.valueOf(useAvroLogicalTypes)).setDestinationUris((List)ImmutableList.of((Object)destinationUri));
        try {
            LOG.info("Starting BigQuery extract job: {}", (Object)jobId);
            jobService.startExtractJob(jobRef, extract);
            extractJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
        }
        catch (IOException exn) {
            LOG.warn("Error extracting table: {} Note that external tables cannot be exported: https://cloud.google.com/bigquery/docs/external-tables#external_table_limitations", (Throwable)exn);
            throw exn;
        }
        if (BigQueryHelpers.parseStatus(extractJob) != BigQueryHelpers.Status.SUCCEEDED) {
            throw new IOException(String.format("Extract job %s failed, status: %s.", extractJob.getJobReference().getJobId(), BigQueryHelpers.statusToPrettyString(extractJob.getStatus())));
        }
        LOG.info("BigQuery extract job completed: {}", (Object)jobId);
        return BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob);
    }

    List<BoundedSource<T>> createSources(List<ResourceId> files, TableSchema schema, @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    MatchResult.Metadata> metadata) throws IOException, InterruptedException {
        String avroSchema = BigQueryAvroUtils.toGenericAvroSchema("root", schema.getFields()).toString();
        AvroSource.DatumReaderFactory factory = (AvroSource.DatumReaderFactory)this.readerFactory.apply((Object)schema);
        ArrayList avroSources = Lists.newArrayList();
        if (metadata != null) {
            for (MatchResult.Metadata file : metadata) {
                avroSources.add(AvroSource.from((MatchResult.Metadata)file).withSchema(avroSchema).withDatumReaderFactory(factory));
            }
        } else {
            for (ResourceId file : files) {
                avroSources.add(AvroSource.from((String)file.toString()).withSchema(avroSchema).withDatumReaderFactory(factory));
            }
        }
        return ImmutableList.copyOf((Collection)avroSources);
    }

    protected static class ExtractResult {
        public final TableSchema schema;
        public final List<ResourceId> extractedFiles;
        public @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
        MatchResult.Metadata> metadata = null;

        public ExtractResult(TableSchema schema, List<ResourceId> extractedFiles) {
            this(schema, extractedFiles, null);
        }

        public ExtractResult(TableSchema schema, List<ResourceId> extractedFiles, @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
        MatchResult.Metadata> metadata) {
            this.schema = schema;
            this.extractedFiles = extractedFiles;
            this.metadata = metadata;
        }
    }
}

