/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.common.ICsvInputAwareMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputAdditionalField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputFiles;
import org.apache.hop.pipeline.transforms.file.BaseFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileFilter;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInput;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="TextFileInput2", image="textfileinput.svg", name="i18n::TextFileInput.Name", description="i18n::TextFileInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::TextFileInputMeta.keyword"}, documentationUrl="/pipeline/transforms/textfileinput.html")
@InjectionSupported(localizationPrefix="TextFileInput.Injection.", groups={"FILENAME_LINES", "FIELDS", "FILTERS"})
public class TextFileInputMeta
extends BaseFileInputMeta<TextFileInput, TextFileInputData, BaseFileInputAdditionalField, BaseFileInputFiles, BaseFileField>
implements ICsvInputAwareMeta {
    private static final Class<?> PKG = TextFileInputMeta.class;
    private static final String STRING_BASE64_PREFIX = "Base64: ";
    @InjectionDeep
    public Content content = new Content();
    @InjectionDeep
    private TextFileFilter[] filter = new TextFileFilter[0];
    @Injection(name="ERROR_COUNT_FIELD")
    public String errorCountField;
    @Injection(name="ERROR_FIELDS_FIELD")
    public String errorFieldsField;
    @Injection(name="ERROR_TEXT_FIELD")
    public String errorTextField;
    @Injection(name="ERROR_LINES_SKIPPED")
    public boolean errorLineSkipped;
    private TransformMeta acceptingTransform;

    public TextFileInputMeta() {
        this.additionalOutputFields = new BaseFileInputAdditionalField();
        this.inputFiles = new BaseFileInputFiles();
        this.inputFields = new BaseFileField[0];
    }

    public String[] getFileName() {
        return this.inputFiles.fileName;
    }

    public void setFileName(String[] fileName) {
        this.inputFiles.fileName = fileName;
    }

    public TextFileFilter[] getFilter() {
        return this.filter;
    }

    public void setFilter(TextFileFilter[] filter) {
        this.filter = filter;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node fnode;
            int i;
            this.inputFiles.acceptingFilenames = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"accept_filenames"));
            this.inputFiles.passingThruFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"passing_through_fields"));
            this.inputFiles.acceptingField = XmlHandler.getTagValue((Node)transformNode, (String)"accept_field");
            this.inputFiles.acceptingTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"accept_transform_name");
            this.content.separator = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
            this.content.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
            this.content.breakInEnclosureAllowed = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_breaks"));
            this.content.escapeCharacter = XmlHandler.getTagValue((Node)transformNode, (String)"escapechar");
            this.content.header = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"header"));
            this.content.nrHeaderLines = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_headerlines"), (int)1);
            this.content.footer = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"footer"));
            this.content.nrFooterLines = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_footerlines"), (int)1);
            this.content.lineWrapped = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"line_wrapped"));
            this.content.nrWraps = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_wraps"), (int)1);
            this.content.layoutPaged = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"layout_paged"));
            this.content.nrLinesPerPage = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_lines_per_page"), (int)1);
            this.content.nrLinesDocHeader = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"nr_lines_doc_header"), (int)1);
            String addToResult = XmlHandler.getTagValue((Node)transformNode, (String)"add_to_result_filenames");
            this.inputFiles.isaddresult = Utils.isEmpty((CharSequence)addToResult) ? true : "Y".equalsIgnoreCase(addToResult);
            String nempty = XmlHandler.getTagValue((Node)transformNode, (String)"noempty");
            this.content.noEmptyLines = "Y".equalsIgnoreCase(nempty) || nempty == null;
            this.content.includeFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include"));
            this.content.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"include_field");
            this.content.includeRowNumber = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.content.rowNumberByFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownumByFile"));
            this.content.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.content.fileFormat = XmlHandler.getTagValue((Node)transformNode, (String)"format");
            this.content.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.content.length = XmlHandler.getTagValue((Node)transformNode, (String)"length");
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            Node filtersNode = XmlHandler.getSubNode((Node)transformNode, (String)"filters");
            int nrfiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            int nrfilters = XmlHandler.countNodes((Node)filtersNode, (String)"filter");
            this.allocate(nrfiles, nrFields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.inputFiles.fileName[i] = this.loadSource(filenode, filenamenode, i, metadataProvider);
                this.inputFiles.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.inputFiles.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.inputFiles.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.inputFiles.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            this.content.fileType = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"type");
            this.content.fileCompression = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"compression");
            if (this.content.fileCompression == null) {
                this.content.fileCompression = "None";
                if ("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"zipped"))) {
                    this.content.fileCompression = "Zip";
                }
            }
            if (XmlHandler.getTagValue((Node)transformNode, (String)"filter") != null) {
                this.filter = new TextFileFilter[1];
                this.filter[0] = new TextFileFilter();
                this.filter[0].setFilterPosition(Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"filter_position"), (int)-1));
                this.filter[0].setFilterString(XmlHandler.getTagValue((Node)transformNode, (String)"filter_string"));
                this.filter[0].setFilterLastLine("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"filter_is_last_line")));
                this.filter[0].setFilterPositive("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"filter_is_positive")));
            } else {
                for (i = 0; i < nrfilters; ++i) {
                    fnode = XmlHandler.getSubNodeByNr((Node)filtersNode, (String)"filter", (int)i);
                    this.filter[i] = new TextFileFilter();
                    this.filter[i].setFilterPosition(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"filter_position"), (int)-1));
                    String filterString = XmlHandler.getTagValue((Node)fnode, (String)"filter_string");
                    if (filterString != null && filterString.startsWith(STRING_BASE64_PREFIX)) {
                        this.filter[i].setFilterString(new String(Base64.decodeBase64((byte[])filterString.substring(STRING_BASE64_PREFIX.length()).getBytes())));
                    } else {
                        this.filter[i].setFilterString(filterString);
                    }
                    this.filter[i].setFilterLastLine("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"filter_is_last_line")));
                    this.filter[i].setFilterPositive("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"filter_is_positive")));
                }
            }
            for (i = 0; i < nrFields; ++i) {
                fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                BaseFileField field = new BaseFileField();
                field.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                field.setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                field.setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                field.setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                field.setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                field.setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
                field.setIfNullValue(XmlHandler.getTagValue((Node)fnode, (String)"ifnull"));
                field.setPosition(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"position"), (int)-1));
                field.setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                field.setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                field.setTrimType(ValueMetaString.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                field.setRepeated("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"repeat")));
                this.inputFields[i] = field;
            }
            this.content.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            this.errorHandling.errorIgnored = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"error_ignored"));
            this.errorHandling.skipBadFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"skip_bad_files"));
            this.errorHandling.fileErrorField = XmlHandler.getTagValue((Node)transformNode, (String)"file_error_field");
            this.errorHandling.fileErrorMessageField = XmlHandler.getTagValue((Node)transformNode, (String)"file_error_message_field");
            this.errorLineSkipped = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"error_line_skipped"));
            this.errorCountField = XmlHandler.getTagValue((Node)transformNode, (String)"error_count_field");
            this.errorFieldsField = XmlHandler.getTagValue((Node)transformNode, (String)"error_fields_field");
            this.errorTextField = XmlHandler.getTagValue((Node)transformNode, (String)"error_text_field");
            this.errorHandling.warningFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"bad_line_files_destination_directory");
            this.errorHandling.warningFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"bad_line_files_extension");
            this.errorHandling.errorFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"error_line_files_destination_directory");
            this.errorHandling.errorFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"error_line_files_extension");
            this.errorHandling.lineNumberFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"line_number_files_destination_directory");
            this.errorHandling.lineNumberFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"line_number_files_extension");
            this.content.dateFormatLenient = !"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"date_format_lenient"));
            String dateLocale = XmlHandler.getTagValue((Node)transformNode, (String)"date_format_locale");
            this.content.dateFormatLocale = dateLocale != null ? EnvUtil.createLocale((String)dateLocale) : Locale.getDefault();
            this.additionalOutputFields.shortFilenameField = XmlHandler.getTagValue((Node)transformNode, (String)"shortFileFieldName");
            this.additionalOutputFields.pathField = XmlHandler.getTagValue((Node)transformNode, (String)"pathFieldName");
            this.additionalOutputFields.hiddenField = XmlHandler.getTagValue((Node)transformNode, (String)"hiddenFieldName");
            this.additionalOutputFields.lastModificationField = XmlHandler.getTagValue((Node)transformNode, (String)"lastModificationTimeFieldName");
            this.additionalOutputFields.uriField = XmlHandler.getTagValue((Node)transformNode, (String)"uriNameFieldName");
            this.additionalOutputFields.rootUriField = XmlHandler.getTagValue((Node)transformNode, (String)"rootUriNameFieldName");
            this.additionalOutputFields.extensionField = XmlHandler.getTagValue((Node)transformNode, (String)"extensionFieldName");
            this.additionalOutputFields.sizeField = XmlHandler.getTagValue((Node)transformNode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public Object clone() {
        int i;
        TextFileInputMeta retval = (TextFileInputMeta)((Object)super.clone());
        retval.inputFiles = (BaseFileInputFiles)this.inputFiles.clone();
        retval.inputFields = new BaseFileField[this.inputFields.length];
        for (i = 0; i < this.inputFields.length; ++i) {
            retval.inputFields[i] = (BaseFileField)this.inputFields[i].clone();
        }
        retval.filter = new TextFileFilter[this.filter.length];
        for (i = 0; i < this.filter.length; ++i) {
            retval.filter[i] = (TextFileFilter)this.filter[i].clone();
        }
        return retval;
    }

    public void allocate(int nrfiles, int nrFields, int nrfilters) {
        this.allocateFiles(nrfiles);
        this.inputFields = new BaseFileField[nrFields];
        this.filter = new TextFileFilter[nrfilters];
    }

    public void allocateFiles(int nrFiles) {
        this.inputFiles.fileName = new String[nrFiles];
        this.inputFiles.fileMask = new String[nrFiles];
        this.inputFiles.excludeFileMask = new String[nrFiles];
        this.inputFiles.fileRequired = new String[nrFiles];
        this.inputFiles.includeSubFolders = new String[nrFiles];
    }

    public void setDefault() {
        int i;
        this.additionalOutputFields.shortFilenameField = null;
        this.additionalOutputFields.pathField = null;
        this.additionalOutputFields.hiddenField = null;
        this.additionalOutputFields.lastModificationField = null;
        this.additionalOutputFields.uriField = null;
        this.additionalOutputFields.rootUriField = null;
        this.additionalOutputFields.extensionField = null;
        this.additionalOutputFields.sizeField = null;
        this.inputFiles.isaddresult = true;
        this.content.separator = ";";
        this.content.enclosure = "\"";
        this.content.breakInEnclosureAllowed = false;
        this.content.header = true;
        this.content.nrHeaderLines = 1;
        this.content.footer = false;
        this.content.nrFooterLines = 1;
        this.content.lineWrapped = false;
        this.content.nrWraps = 1;
        this.content.layoutPaged = false;
        this.content.nrLinesPerPage = 80;
        this.content.nrLinesDocHeader = 0;
        this.content.fileCompression = "None";
        this.content.noEmptyLines = true;
        this.content.fileFormat = "DOS";
        this.content.fileType = "CSV";
        this.content.includeFilename = false;
        this.content.filenameField = "";
        this.content.includeRowNumber = false;
        this.content.rowNumberField = "";
        this.content.dateFormatLenient = true;
        this.content.rowNumberByFile = false;
        this.errorHandling.errorIgnored = false;
        this.errorHandling.skipBadFiles = false;
        this.errorLineSkipped = false;
        this.errorHandling.warningFilesDestinationDirectory = null;
        this.errorHandling.warningFilesExtension = "warning";
        this.errorHandling.errorFilesDestinationDirectory = null;
        this.errorHandling.errorFilesExtension = "error";
        this.errorHandling.lineNumberFilesDestinationDirectory = null;
        this.errorHandling.lineNumberFilesExtension = "line";
        int nrfiles = 0;
        int nrFields = 0;
        int nrfilters = 0;
        this.allocate(nrfiles, nrFields, nrfilters);
        for (i = 0; i < nrfiles; ++i) {
            this.inputFiles.fileName[i] = "filename" + (i + 1);
            this.inputFiles.fileMask[i] = "";
            this.inputFiles.excludeFileMask[i] = "";
            this.inputFiles.fileRequired[i] = "N";
            this.inputFiles.includeSubFolders[i] = "N";
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new BaseFileField("field" + (i + 1), 1, -1);
        }
        this.content.dateFormatLocale = Locale.getDefault();
        this.content.rowLimit = 0L;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.inputFiles.passingThruFields) {
            row.clear();
        } else if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                row.mergeRowMeta(info[i], name);
                found = true;
            }
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            BaseFileField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)type);
                v.setLength(field.getLength());
                v.setPrecision(field.getPrecision());
                v.setOrigin(name);
                v.setConversionMask(field.getFormat());
                v.setDecimalSymbol(field.getDecimalSymbol());
                v.setGroupingSymbol(field.getGroupSymbol());
                v.setCurrencySymbol(field.getCurrencySymbol());
                v.setDateFormatLenient(this.content.dateFormatLenient);
                v.setDateFormatLocale(this.content.dateFormatLocale);
                v.setTrimType(field.getTrimType());
                row.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.errorHandling.errorIgnored) {
            if (this.errorCountField != null && this.errorCountField.length() > 0) {
                ValueMetaInteger v = new ValueMetaInteger(this.errorCountField);
                v.setLength(10, 0);
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
            if (this.errorFieldsField != null && this.errorFieldsField.length() > 0) {
                ValueMetaString v = new ValueMetaString(this.errorFieldsField);
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
            if (this.errorTextField != null && this.errorTextField.length() > 0) {
                ValueMetaString v = new ValueMetaString(this.errorTextField);
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
        }
        if (this.content.includeFilename) {
            ValueMetaString v = new ValueMetaString(this.content.filenameField);
            v.setLength(100);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.content.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(this.content.rowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.shortFilenameField)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.additionalOutputFields.shortFilenameField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.extensionField)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.additionalOutputFields.extensionField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.pathField)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.additionalOutputFields.pathField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.sizeField)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.additionalOutputFields.sizeField));
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.hiddenField)) {
            ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.additionalOutputFields.hiddenField));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.lastModificationField)) {
            ValueMetaDate v = new ValueMetaDate(variables.resolve(this.additionalOutputFields.lastModificationField));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.uriField)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.additionalOutputFields.uriField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.rootUriField)) {
            ValueMetaString v = new ValueMetaString(this.additionalOutputFields.rootUriField);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(1500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_filenames", (boolean)this.inputFiles.acceptingFilenames));
        retval.append("    ").append(XmlHandler.addTagValue((String)"passing_through_fields", (boolean)this.inputFiles.passingThruFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_field", (String)this.inputFiles.acceptingField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_transform_name", (String)(this.acceptingTransform != null ? this.acceptingTransform.getName() : "")));
        retval.append("    ").append(XmlHandler.addTagValue((String)"separator", (String)this.content.separator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.content.enclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_breaks", (boolean)this.content.breakInEnclosureAllowed));
        retval.append("    ").append(XmlHandler.addTagValue((String)"escapechar", (String)this.content.escapeCharacter));
        retval.append("    ").append(XmlHandler.addTagValue((String)"header", (boolean)this.content.header));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_headerlines", (int)this.content.nrHeaderLines));
        retval.append("    ").append(XmlHandler.addTagValue((String)"footer", (boolean)this.content.footer));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_footerlines", (int)this.content.nrFooterLines));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_wrapped", (boolean)this.content.lineWrapped));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_wraps", (int)this.content.nrWraps));
        retval.append("    ").append(XmlHandler.addTagValue((String)"layout_paged", (boolean)this.content.layoutPaged));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_lines_per_page", (int)this.content.nrLinesPerPage));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nr_lines_doc_header", (int)this.content.nrLinesDocHeader));
        retval.append("    ").append(XmlHandler.addTagValue((String)"noempty", (boolean)this.content.noEmptyLines));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include", (boolean)this.content.includeFilename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_field", (String)this.content.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.content.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownumByFile", (boolean)this.content.rowNumberByFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.content.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"format", (String)this.content.fileFormat));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.content.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"length", (String)this.content.length));
        retval.append("    " + XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.inputFiles.isaddresult));
        retval.append("    <file>").append(Const.CR);
        this.inputFiles.normalizeAllocation(this.inputFiles.fileName.length);
        for (i = 0; i < this.inputFiles.fileName.length; ++i) {
            this.saveSource(retval, this.inputFiles.fileName[i]);
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.inputFiles.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.inputFiles.excludeFileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.inputFiles.fileRequired[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.inputFiles.includeSubFolders[i]));
        }
        retval.append("      ").append(XmlHandler.addTagValue((String)"type", (String)this.content.fileType));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compression", (String)(this.content.fileCompression == null ? "None" : this.content.fileCompression)));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <filters>").append(Const.CR);
        for (i = 0; i < this.filter.length; ++i) {
            String filterString = this.filter[i].getFilterString();
            byte[] filterBytes = new byte[]{};
            String filterPrefix = "";
            if (filterString != null) {
                filterBytes = filterString.getBytes();
                filterPrefix = STRING_BASE64_PREFIX;
            }
            String filterEncoded = filterPrefix + new String(Base64.encodeBase64((byte[])filterBytes));
            retval.append("      <filter>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"filter_string", (String)filterEncoded, (boolean)false, (String[])new String[0]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"filter_position", (int)this.filter[i].getFilterPosition(), (boolean)false));
            retval.append("        ").append(XmlHandler.addTagValue((String)"filter_is_last_line", (boolean)this.filter[i].isFilterLastLine(), (boolean)false));
            retval.append("        ").append(XmlHandler.addTagValue((String)"filter_is_positive", (boolean)this.filter[i].isFilterPositive(), (boolean)false));
            retval.append("      </filter>").append(Const.CR);
        }
        retval.append("    </filters>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            BaseFileField field = this.inputFields[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"ifnull", (String)field.getIfNullValue()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"position", (int)field.getPosition()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"repeat", (boolean)field.isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.content.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_ignored", (boolean)this.errorHandling.errorIgnored));
        retval.append("    ").append(XmlHandler.addTagValue((String)"skip_bad_files", (boolean)this.errorHandling.skipBadFiles));
        retval.append("    ").append(XmlHandler.addTagValue((String)"file_error_field", (String)this.errorHandling.fileErrorField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"file_error_message_field", (String)this.errorHandling.fileErrorMessageField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_skipped", (boolean)this.errorLineSkipped));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_count_field", (String)this.errorCountField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_fields_field", (String)this.errorFieldsField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_text_field", (String)this.errorTextField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bad_line_files_destination_directory", (String)this.errorHandling.warningFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bad_line_files_extension", (String)this.errorHandling.warningFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_files_destination_directory", (String)this.errorHandling.errorFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_files_extension", (String)this.errorHandling.errorFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_number_files_destination_directory", (String)this.errorHandling.lineNumberFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_number_files_extension", (String)this.errorHandling.lineNumberFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"date_format_lenient", (boolean)this.content.dateFormatLenient));
        retval.append("    ").append(XmlHandler.addTagValue((String)"date_format_locale", this.content.dateFormatLocale != null ? this.content.dateFormatLocale.toString() : null));
        retval.append("    ").append(XmlHandler.addTagValue((String)"shortFileFieldName", (String)this.additionalOutputFields.shortFilenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"pathFieldName", (String)this.additionalOutputFields.pathField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"hiddenFieldName", (String)this.additionalOutputFields.hiddenField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.additionalOutputFields.lastModificationField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"uriNameFieldName", (String)this.additionalOutputFields.uriField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rootUriNameFieldName", (String)this.additionalOutputFields.rootUriField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"extensionFieldName", (String)this.additionalOutputFields.extensionField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sizeFieldName", (String)this.additionalOutputFields.sizeField));
        return retval.toString();
    }

    public String getLookupTransformName() {
        if (this.inputFiles.acceptingFilenames && this.acceptingTransform != null && !Utils.isEmpty((CharSequence)this.acceptingTransform.getName())) {
            return this.acceptingTransform.getName();
        }
        return null;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.acceptingTransform = TransformMeta.findTransform(transforms, (String)this.inputFiles.acceptingTransformName);
    }

    public String[] getInfoTransforms() {
        if (this.inputFiles.acceptingFilenames && this.acceptingTransform != null) {
            return new String[]{this.acceptingTransform.getName()};
        }
        return null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.inputFiles.acceptingFilenames) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList textFileList = this.getFileInputList(variables);
        if (textFileList.nrOfFiles() == 0) {
            if (!this.inputFiles.acceptingFilenames) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + textFileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getErrorCountField() {
        return this.errorCountField;
    }

    public void setErrorCountField(String errorCountField) {
        this.errorCountField = errorCountField;
    }

    public String getErrorFieldsField() {
        return this.errorFieldsField;
    }

    public void setErrorFieldsField(String errorFieldsField) {
        this.errorFieldsField = errorFieldsField;
    }

    public String getErrorTextField() {
        return this.errorTextField;
    }

    public void setErrorTextField(String errorTextField) {
        this.errorTextField = errorTextField;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    public void setAcceptingTransform(TransformMeta acceptingTransform) {
        this.acceptingTransform = acceptingTransform;
    }

    public int getFileFormatTypeNr() {
        if (this.content.fileFormat.equalsIgnoreCase("DOS")) {
            return 0;
        }
        if (this.content.fileFormat.equalsIgnoreCase("unix")) {
            return 1;
        }
        return 2;
    }

    public int getFileTypeNr() {
        if (this.content.fileType.equalsIgnoreCase("CSV")) {
            return 0;
        }
        return 1;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.inputFiles.acceptingFilenames) {
                for (int i = 0; i < this.inputFiles.fileName.length; ++i) {
                    String fileName = this.inputFiles.fileName[i];
                    if (fileName == null || fileName.isEmpty()) continue;
                    FileObject fileObject = this.getFileObject(variables.resolve(fileName), variables);
                    this.inputFiles.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.inputFiles.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return this.errorHandling.errorIgnored && this.errorHandling.skipBadFiles;
    }

    @VisibleForTesting
    public void setFileNameForTest(String[] fileName) {
        this.allocateFiles(fileName.length);
        this.setFileName(fileName);
    }

    protected String loadSource(Node filenode, Node filenamenode, int i, IHopMetadataProvider metadataProvider) {
        return XmlHandler.getNodeValue((Node)filenamenode);
    }

    protected void saveSource(StringBuilder retVal, String source) {
        retVal.append("      ").append(XmlHandler.addTagValue((String)"name", (String)source));
    }

    public String getEncoding() {
        return this.content.encoding;
    }

    public String getLength() {
        return this.content.length;
    }

    public void setLength(String length) {
        this.content.length = length;
    }

    public boolean isAcceptingFilenames() {
        return this.inputFiles.acceptingFilenames;
    }

    public String getAcceptingTransformName() {
        return this.inputFiles.acceptingTransformName;
    }

    public TransformMeta getAcceptingTransform() {
        return this.acceptingTransform;
    }

    public String getAcceptingField() {
        return this.inputFiles.acceptingField;
    }

    public String[] getFilePaths(IVariables variables) {
        return FileInputList.createFilePathList((IVariables)variables, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.inputFiles.includeSubFolderBoolean());
    }

    public FileInputList getTextFileList(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.inputFiles.includeSubFolderBoolean());
    }

    FileObject getFileObject(String vfsFileName, IVariables variables) throws HopFileException {
        return HopVfs.getFileObject((String)variables.resolve(vfsFileName));
    }

    public boolean hasHeader() {
        return this.content == null ? false : this.content.header;
    }

    public String getEscapeCharacter() {
        return this.content == null ? null : this.content.escapeCharacter;
    }

    public String getDelimiter() {
        return this.content == null ? null : this.content.separator;
    }

    public String getEnclosure() {
        return this.content == null ? null : this.content.enclosure;
    }

    public FileObject getHeaderFileObject(IVariables variables) {
        FileInputList fileList = this.getFileInputList(variables);
        return fileList.nrOfFiles() == 0 ? null : fileList.getFile(0);
    }

    public static class Content
    implements Cloneable {
        @Injection(name="FILE_TYPE")
        public String fileType;
        @Injection(name="SEPARATOR")
        public String separator;
        @Injection(name="ENCLOSURE")
        public String enclosure;
        @Injection(name="BREAK_IN_ENCLOSURE")
        public boolean breakInEnclosureAllowed;
        @Injection(name="ESCAPE_CHAR")
        public String escapeCharacter;
        @Injection(name="HEADER_PRESENT")
        public boolean header;
        @Injection(name="NR_HEADER_LINES")
        public int nrHeaderLines = -1;
        @Injection(name="HAS_FOOTER")
        public boolean footer;
        @Injection(name="NR_FOOTER_LINES")
        public int nrFooterLines = -1;
        @Injection(name="HAS_WRAPPED_LINES")
        public boolean lineWrapped;
        @Injection(name="NR_WRAPS")
        public int nrWraps = -1;
        @Injection(name="HAS_PAGED_LAYOUT")
        public boolean layoutPaged;
        @Injection(name="NR_LINES_PER_PAGE")
        public int nrLinesPerPage = -1;
        @Injection(name="NR_DOC_HEADER_LINES")
        public int nrLinesDocHeader = -1;
        @Injection(name="COMPRESSION_TYPE")
        public String fileCompression;
        @Injection(name="NO_EMPTY_LINES")
        public boolean noEmptyLines;
        @Injection(name="INCLUDE_FILENAME")
        public boolean includeFilename;
        @Injection(name="FILENAME_FIELD")
        public String filenameField;
        @Injection(name="INCLUDE_ROW_NUMBER")
        public boolean includeRowNumber;
        @Injection(name="ROW_NUMBER_FIELD")
        public String rowNumberField;
        @Injection(name="ROW_NUMBER_BY_FILE")
        public boolean rowNumberByFile;
        @Injection(name="FILE_FORMAT")
        public String fileFormat;
        @Injection(name="ENCODING")
        public String encoding;
        @Injection(name="ROW_LIMIT")
        public long rowLimit = -1L;
        @Injection(name="DATE_FORMAT_LENIENT")
        public boolean dateFormatLenient;
        public Locale dateFormatLocale;
        @Injection(name="LENGTH")
        public String length;

        @Injection(name="DATE_FORMAT_LOCALE")
        public void setDateFormatLocale(String locale) {
            this.dateFormatLocale = new Locale(locale);
        }
    }
}

