/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.partition.PartitionSchema;

@SearchableAnalyserPlugin(id="PartitionSchemaSearchableAnalyser", name="Search in partition schema metadata")
public class PartitionSchemaSearchableAnalyser
extends BaseMetadataSearchableAnalyser<PartitionSchema>
implements ISearchableAnalyser<PartitionSchema> {
    @Override
    public Class<PartitionSchema> getSearchableClass() {
        return PartitionSchema.class;
    }

    public List<ISearchResult> search(ISearchable<PartitionSchema> searchable, ISearchQuery searchQuery) {
        PartitionSchema partitionSchema = (PartitionSchema)searchable.getSearchableObject();
        String component = this.getMetadataComponent();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "Partition schema name", partitionSchema.getName(), component);
        this.matchProperty(searchable, results, searchQuery, "Partition schema number of partitions", partitionSchema.getNumberOfPartitions(), component);
        return results;
    }
}

