/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskMetrics;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.TaskStatus;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\t5d!B\u0006\r\u00011A\u0002\"B\u0012\u0001\t\u0003)\u0003\"B\u0014\u0001\t\u0003A\u0003bBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a%\u0001\t\u0003\t)\nC\u0004\u0002d\u0002!\t!!:\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!\u0011\t\u0001\u0005\u0002\t\r\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0002\u000f'R\fw-Z:SKN|WO]2f\u0015\tia\"\u0001\u0002wc)\u0011q\u0002E\u0001\u0004CBL'BA\t\u0013\u0003\u0019\u0019H/\u0019;vg*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xmE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005a\u0011B\u0001\u0012\r\u0005=\u0011\u0015m]3BaB\u0014Vm]8ve\u000e,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0019\u0002\"\u0001\t\u0001\u0002\u0013M$\u0018mZ3MSN$HCB\u00159%~#G\u000fE\u0002+eUr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u00059\"\u0013A\u0002\u001fs_>$h(C\u0001\u001d\u0013\t\t4$A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$aA*fc*\u0011\u0011g\u0007\t\u0003AYJ!a\u000e\u0007\u0003\u0013M#\u0018mZ3ECR\f\u0007\"B\u001d\u0003\u0001\u0004Q\u0014\u0001C:uCR,8/Z:\u0011\u0007m\u0002%)D\u0001=\u0015\tid(\u0001\u0003vi&d'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012A\u0001T5tiB\u0011\u0001eQ\u0005\u0003\t2\u00111b\u0015;bO\u0016\u001cF/\u0019;vg\"\"\u0001H\u0012)R!\t9e*D\u0001I\u0015\tI%*\u0001\u0002sg*\u00111\nT\u0001\u0003oNT\u0011!T\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u001f\"\u0013!\"U;fef\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\u0005\t\u0002\"B*\u0003\u0001\u0004!\u0016a\u00023fi\u0006LGn\u001d\t\u00035UK!AV\u000e\u0003\u000f\t{w\u000e\\3b]\"\"!\u000b\u0017)\\!\t9\u0015,\u0003\u0002[\u0011\naA)\u001a4bk2$h+\u00197vK\u0006\nA,A\u0003gC2\u001cX\r\u000b\u0003S\rBs\u0016%A*\t\u000b\u0001\u0014\u0001\u0019\u0001+\u0002\u001b]LG\u000f[*v[6\f'/[3tQ\u0011y\u0006\fU.)\t}3\u0005kY\u0011\u0002A\")QM\u0001a\u0001M\u0006q\u0011/^1oi&dWm\u0015;sS:<\u0007CA4l\u001d\tA\u0017\u000e\u0005\u0002-7%\u0011!nG\u0001\u0007!J,G-\u001a4\n\u00051l'AB*ue&twM\u0003\u0002k7!\"A\r\u0017)pC\u0005\u0001\u0018!\u0006\u0019/a1\u0002dFM\u001b-a9*D\u0006\r\u00188k1\nd\u0006\r\u0015\u0005I\u001a\u0003&/I\u0001t\u0003%\tX/\u00198uS2,7\u000fC\u0003v\u0005\u0001\u0007a/\u0001\u0006uCN\\7\u000b^1ukN\u00042a\u000f!x!\t\u0001\u00030\u0003\u0002z\u0019\tQA+Y:l'R\fG/^:)\tQ4\u0005k_\u0011\u0002k\"\u0012!! \t\u0003\u000fzL!a %\u0003\u0007\u001d+E+A\u0005ti\u0006<W\rR1uCRY\u0011&!\u0002\u0002\u001a\u0005\r\u0012qEA\u0017\u0011\u001d\t9a\u0001a\u0001\u0003\u0013\tqa\u001d;bO\u0016LE\rE\u0002\u001b\u0003\u0017I1!!\u0004\u001c\u0005\rIe\u000e\u001e\u0015\b\u0003\u000b\t\t\u0002UA\f!\r9\u00151C\u0005\u0004\u0003+A%!\u0003)bi\"\u0004\u0016M]1nC\t\t9\u0001C\u0003T\u0007\u0001\u0007A\u000b\u000b\u0004\u0002\u001aa\u0003\u0016QD\u0011\u0003\u0003?\tA\u0001\u001e:vK\"*\u0011\u0011\u0004$Q=\")Qo\u0001a\u0001m\"*\u00111\u0005$Qw\")\u0001m\u0001a\u0001)\"*\u0011q\u0005-Q7\"*\u0011q\u0005$QG\")Qm\u0001a\u0001M\"*\u0011Q\u0006-Q_\"*\u0011Q\u0006$Qe\"21!!\u000eQ\u0003w\u00012aRA\u001c\u0013\r\tI\u0004\u0013\u0002\u0005!\u0006$\b.\t\u0002\u0002>\u0005q1p\u001d;bO\u0016LEM\u000f\u0011]I.j\bFA\u0002~\u00039yg.Z!ui\u0016l\u0007\u000f\u001e#bi\u0006$R\"NA#\u0003\u0013\n\t&a\u0016\u0002\\\u0005\u0005\u0004bBA\u0004\t\u0001\u0007\u0011\u0011\u0002\u0015\b\u0003\u000b\n\t\u0002UA\f\u0011\u001d\tY\u0005\u0002a\u0001\u0003\u0013\tab\u001d;bO\u0016\fE\u000f^3naRLE\rK\u0004\u0002J\u0005E\u0001+a\u0014\"\u0005\u0005-\u0003\"B*\u0005\u0001\u0004!\u0006FBA)1B\u000bi\u0002K\u0003\u0002R\u0019\u0003f\fC\u0003v\t\u0001\u0007a\u000fK\u0003\u0002X\u0019\u00036\u0010C\u0003a\t\u0001\u0007A\u000bK\u0003\u0002\\a\u00036\fK\u0003\u0002\\\u0019\u00036\rC\u0003f\t\u0001\u0007a\rK\u0003\u0002ba\u0003v\u000eK\u0003\u0002b\u0019\u0003&\u000f\u000b\u0004\u0005\u0003k\u0001\u0016\u0011N\u0011\u0003\u0003W\nAe_:uC\u001e,\u0017\n\u001a\u001e!9\u0012\\SpL>ti\u0006<W-\u0011;uK6\u0004H/\u00133;Aq#7& \u0015\u0003\tu\f1\u0002^1tWN+X.\\1ssRA\u00111OA=\u0003{\n\t\tE\u0002!\u0003kJ1!a\u001e\r\u0005]!\u0016m]6NKR\u0014\u0018n\u0019#jgR\u0014\u0018NY;uS>t7\u000fC\u0004\u0002\b\u0015\u0001\r!!\u0003)\u000f\u0005e\u0014\u0011\u0003)\u0002\u0018!9\u00111J\u0003A\u0002\u0005%\u0001fBA?\u0003#\u0001\u0016q\n\u0005\u0006K\u0016\u0001\rA\u001a\u0015\u0006\u0003\u00033\u0005K\u001d\u0015\u0007\u0003\u0003C\u0006+a\"\"\u0005\u0005%\u0015a\u0006\u0019/aUb\u0003G\f\u001a6YArS\u0007\f\u0019/oUb\u0003GL\u001d6Q\u0019)\u0011Q\u0007)\u0002\u000e\u0006\u0012\u0011qR\u00011wN$\u0018mZ3JIj\u0002C\fZ\u0016~_m\u001cH/Y4f\u0003R$X-\u001c9u\u0013\u0012T\u0004\u0005\u00183,{>\"\u0018m]6Tk6l\u0017M]=)\u0005\u0015i\u0018\u0001\u0003;bg.d\u0015n\u001d;\u0015\u001d\u0005]\u0015qTAR\u0003O\u000b),a1\u0002XB!!FMAM!\r\u0001\u00131T\u0005\u0004\u0003;c!\u0001\u0003+bg.$\u0015\r^1\t\u000f\u0005\u001da\u00011\u0001\u0002\n!:\u0011qTA\t!\u0006]\u0001bBA&\r\u0001\u0007\u0011\u0011\u0002\u0015\b\u0003G\u000b\t\u0002UA(\u0011\u001d\tIK\u0002a\u0001\u0003\u0013\taa\u001c4gg\u0016$\bFBAT\rB\u000bi+\t\u0002\u0002*\"2\u0011q\u0015-Q\u0003c\u000b#!a-\u0002\u0003ABq!a.\u0007\u0001\u0004\tI!\u0001\u0004mK:<G\u000f\u001b\u0015\u0007\u0003k3\u0005+a/\"\u0005\u0005]\u0006FBA[1B\u000by,\t\u0002\u0002B\u0006\u0011!\u0007\r\u0005\b\u0003\u000b4\u0001\u0019AAd\u0003\u0019\u0019xN\u001d;CsB\u0019\u0001%!3\n\u0007\u0005-GBA\u0006UCN\\7k\u001c:uS:<\u0007FBAb\rB\u000by-\t\u0002\u0002F\"2\u00111\u0019-Q\u0003'\f#!!6\u0002\u0005%#\u0005\"B\u001d\u0007\u0001\u00041\b&BAl\rB\u000b\u0006F\u0002\u0004\u00026A\u000bi.\t\u0002\u0002`\u0006i3p\u001d;bO\u0016LEM\u000f\u0011]I.jxf_:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u001e!9\u0012\\Sp\f;bg.d\u0015n\u001d;)\u0005\u0019i\u0018!\u0003;bg.$\u0016M\u00197f))\t9/!?\u0002~\n\u0005!q\u0001\t\u0007w\u0005%h-!<\n\u0007\u0005-HHA\u0004ICNDW*\u00199\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=?\u0003\u0011a\u0017M\\4\n\t\u0005]\u0018\u0011\u001f\u0002\u0007\u001f\nTWm\u0019;\t\u000f\u0005\u001dq\u00011\u0001\u0002\n!:\u0011\u0011`A\t!\u0006]\u0001bBA&\u000f\u0001\u0007\u0011\u0011\u0002\u0015\b\u0003{\f\t\u0002UA(\u0011\u0015\u0019v\u00011\u0001UQ\u0019\u0011\t\u0001\u0017)\u0002\u001e!*!\u0011\u0001$Q=\"9!\u0011B\u0004A\u0002\t-\u0011aB;sS&sgm\u001c\t\u0005\u0005\u001b\u0011\u0019\"\u0004\u0002\u0003\u0010)\u0019!\u0011\u0003%\u0002\t\r|'/Z\u0005\u0005\u0005+\u0011yAA\u0004Ve&LeNZ8)\t\t\u001d!\u0011\u0004\t\u0005\u0005\u001b\u0011Y\"\u0003\u0003\u0003\u001e\t=!aB\"p]R,\u0007\u0010\u001e\u0015\u0007\u000f\u0005U\u0002K!\t\"\u0005\t\r\u0012AL>ti\u0006<W-\u00133;Aq#7&`\u0018|gR\fw-Z!ui\u0016l\u0007\u000f^%eu\u0001bFmK?0i\u0006\u001c8\u000eV1cY\u0016D#aB?\u0002\u0019\u0011|\u0007+Y4j]\u0006$\u0018n\u001c8\u0015\u0019\u0005]%1\u0006B\u001b\u0005o\u0011ID!\u0010\t\u000f\t5\u0002\u00021\u0001\u00030\u0005y\u0011/^3ssB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0004\u0003\u000e\tEbMZ\u0005\u0005\u0005g\u0011yA\u0001\bNk2$\u0018N^1mk\u0016$W*\u00199\t\u000f\u0005\u001d\u0001\u00021\u0001\u0002\n!9\u00111\n\u0005A\u0002\u0005%\u0001B\u0002B\u001e\u0011\u0001\u0007A+\u0001\u0005jgN+\u0017M]2i\u0011\u001d\u0011y\u0004\u0003a\u0001\u0003\u0013\tA\u0002^8uC2\u0014VmY8sIN\faBZ5mi\u0016\u0014H+Y:l\u0019&\u001cH\u000f\u0006\u0004\u0002\u0018\n\u0015#\u0011\n\u0005\b\u0005\u000fJ\u0001\u0019AAL\u00031!\u0018m]6ECR\fG*[:u\u0011\u0019\u0011Y%\u0003a\u0001M\u0006Y1/Z1sG\"4\u0016\r\\;f\u0003M\u0001\u0018M]:f#V\fg\u000e^5mKN#(/\u001b8h)\u0011\u0011\tF!\u0018\u0011\u000bi\u0011\u0019Fa\u0016\n\u0007\tU3DA\u0003BeJ\f\u0017\u0010E\u0002\u001b\u00053J1Aa\u0017\u001c\u0005\u0019!u.\u001e2mK\")QM\u0003a\u0001M\"2\u0001A!\u0019Q\u0005O\u00022a\u0012B2\u0013\r\u0011)\u0007\u0013\u0002\t!J|G-^2fg2\u0012!\u0011N\u0011\u0003\u0005W\n\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8")
public class StagesResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$(this);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    public Seq<StageData> stageList(@QueryParam(value="status") List<StageStatus> statuses, @QueryParam(value="details") @DefaultValue(value="false") boolean details, @QueryParam(value="withSummaries") @DefaultValue(value="false") boolean withSummaries, @QueryParam(value="quantiles") @DefaultValue(value="0.0,0.25,0.5,0.75,1.0") String quantileString, @QueryParam(value="taskStatus") List<TaskStatus> taskStatus) {
        double[] quantiles = this.parseQuantileString(quantileString);
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)ui -> (Seq)ui.store().stageList(statuses, details, withSummaries, quantiles, taskStatus).filter((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$stageList$2(details, taskStatus, stage))));
    }

    @GET
    @Path(value="{stageId: \\d+}")
    public Seq<StageData> stageData(@PathParam(value="stageId") int stageId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @QueryParam(value="taskStatus") List<TaskStatus> taskStatus, @QueryParam(value="withSummaries") @DefaultValue(value="false") boolean withSummaries, @QueryParam(value="quantiles") @DefaultValue(value="0.0,0.25,0.5,0.75,1.0") String quantileString) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            double[] quantiles = this.parseQuantileString(quantileString);
            Seq<StageData> ret = ui.store().stageData(stageId, details, taskStatus, withSummaries, quantiles);
            if (!ret.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(15).append("unknown stage: ").append(stageId).toString());
            }
            return ret;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}")
    public StageData oneAttemptData(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @QueryParam(value="taskStatus") List<TaskStatus> taskStatus, @QueryParam(value="withSummaries") @DefaultValue(value="false") boolean withSummaries, @QueryParam(value="quantiles") @DefaultValue(value="0.0,0.25,0.5,0.75,1.0") String quantileString) {
        return (StageData)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            StageData stageData;
            try {
                double[] quantiles = this.parseQuantileString(quantileString);
                stageData = (StageData)ui.store().stageAttempt(stageId, stageAttemptId, details, taskStatus, withSummaries, quantiles)._1();
            }
            catch (NoSuchElementException noSuchElementException) {
                String string;
                Seq<StageData> all = ui.store().stageData(stageId, false, taskStatus, ui.store().stageData$default$4(), ui.store().stageData$default$5());
                if (all.nonEmpty()) {
                    Seq ids = (Seq)all.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.attemptId()), Seq$.MODULE$.canBuildFrom());
                    string = new StringBuilder(47).append("unknown attempt for stage ").append(stageId).append(".  Found attempts: [").append(ids.mkString(",")).append("]").toString();
                } else {
                    string = new StringBuilder(15).append("unknown stage: ").append(stageId).toString();
                }
                String msg = string;
                throw new NotFoundException(msg);
            }
            return stageData;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskSummary")
    public TaskMetricDistributions taskSummary(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0.05,0.25,0.5,0.75,0.95") @QueryParam(value="quantiles") String quantileString) {
        return (TaskMetricDistributions)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            double[] quantiles = this.parseQuantileString(quantileString);
            return (TaskMetricDistributions)ui.store().taskSummary(stageId, stageAttemptId, quantiles).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringBuilder(38).append("No tasks reported metrics for ").append(stageId).append(" / ").append(stageAttemptId).append(" yet.").toString());
            });
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskList")
    public Seq<TaskData> taskList(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length, @DefaultValue(value="ID") @QueryParam(value="sortBy") TaskSorting sortBy, @QueryParam(value="status") List<TaskStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$2 -> x$2.store().taskList(stageId, stageAttemptId, offset, length, sortBy, statuses));
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskTable")
    public HashMap<String, Object> taskTable(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @Context UriInfo uriInfo) {
        return (HashMap)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            Object object;
            MultivaluedMap uriQueryParameters = uriInfo.getQueryParameters(true);
            String totalRecords = (String)uriQueryParameters.getFirst((Object)"numTasks");
            boolean isSearch = false;
            String searchValue = null;
            String filteredRecords = totalRecords;
            if (uriQueryParameters.getFirst((Object)"search[value]") != null && ((String)uriQueryParameters.getFirst((Object)"search[value]")).length() > 0) {
                isSearch = true;
                searchValue = (String)uriQueryParameters.getFirst((Object)"search[value]");
            }
            Seq<TaskData> _tasksToShow = this.doPagination((MultivaluedMap<String, String>)uriQueryParameters, stageId, stageAttemptId, isSearch, new StringOps(Predef$.MODULE$.augmentString(totalRecords)).toInt());
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (_tasksToShow.nonEmpty()) {
                if (isSearch) {
                    Seq<TaskData> filteredTaskList = this.filterTaskList(_tasksToShow, searchValue);
                    filteredRecords = Integer.toString(filteredTaskList.length());
                    if (filteredTaskList.length() > 0) {
                        int pageStartIndex = new StringOps(Predef$.MODULE$.augmentString((String)uriQueryParameters.getFirst((Object)"start"))).toInt();
                        int pageLength = new StringOps(Predef$.MODULE$.augmentString((String)uriQueryParameters.getFirst((Object)"length"))).toInt();
                        object = ret.put("aaData", filteredTaskList.slice(pageStartIndex, pageStartIndex + pageLength));
                    } else {
                        object = ret.put("aaData", filteredTaskList);
                    }
                } else {
                    object = ret.put("aaData", _tasksToShow);
                }
            } else {
                object = ret.put("aaData", _tasksToShow);
            }
            ret.put("recordsTotal", totalRecords);
            ret.put("recordsFiltered", filteredRecords);
            return ret;
        });
    }

    public Seq<TaskData> doPagination(MultivaluedMap<String, String> queryParameters, int stageId, int stageAttemptId, boolean isSearch, int totalRecords) {
        IntRef pageLength;
        IntRef pageStartIndex;
        String isAscendingStr;
        ObjectRef columnNameToSort;
        block1: {
            columnNameToSort = ObjectRef.create((Object)((String)queryParameters.getFirst((Object)"columnNameToSort")));
            if (((String)columnNameToSort.elem).equalsIgnoreCase("Logs")) {
                columnNameToSort.elem = "Index";
            }
            isAscendingStr = (String)queryParameters.getFirst((Object)"order[0][dir]");
            pageStartIndex = IntRef.create((int)0);
            pageLength = IntRef.create((int)totalRecords);
            if (isSearch) break block1;
            pageStartIndex.elem = new StringOps(Predef$.MODULE$.augmentString((String)queryParameters.getFirst((Object)"start"))).toInt();
            pageLength.elem = new StringOps(Predef$.MODULE$.augmentString((String)queryParameters.getFirst((Object)"length"))).toInt();
        }
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$3 -> x$3.store().taskList(stageId, stageAttemptId, pageStartIndex$1.elem, pageLength$1.elem, ApiHelper$.MODULE$.indexName((String)columnNameToSort$1.elem), isAscendingStr.equalsIgnoreCase("asc"), x$3.store().taskList$default$7()));
    }

    public Seq<TaskData> filterTaskList(Seq<TaskData> taskDataList, String searchValue) {
        String defaultOptionString = "d";
        String searchValueLowerCase = searchValue.toLowerCase(Locale.ROOT);
        Function1 & Serializable & scala.Serializable containsValue = (Function1 & Serializable & scala.Serializable)taskDataParams -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$1(searchValueLowerCase, taskDataParams));
        Function1 & Serializable & scala.Serializable taskMetricsContainsValue = (Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$2(containsValue, task));
        Seq filteredTaskDataSequence = (Seq)taskDataList.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$3(containsValue, defaultOptionString, taskMetricsContainsValue, f)));
        return filteredTaskDataSequence;
    }

    public double[] parseQuantileString(String quantileString) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])quantileString.split(","))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToDouble((double)StagesResource.$anonfun$parseQuantileString$1(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ boolean $anonfun$stageList$3(StageData stage$1, TaskStatus x0$1) {
        boolean bl;
        TaskStatus taskStatus = x0$1;
        if (((Object)((Object)TaskStatus.FAILED)).equals((Object)taskStatus)) {
            bl = stage$1.numFailedTasks() > 0;
        } else if (((Object)((Object)TaskStatus.KILLED)).equals((Object)taskStatus)) {
            bl = stage$1.numKilledTasks() > 0;
        } else if (((Object)((Object)TaskStatus.RUNNING)).equals((Object)taskStatus)) {
            bl = stage$1.numActiveTasks() > 0;
        } else if (((Object)((Object)TaskStatus.SUCCESS)).equals((Object)taskStatus)) {
            bl = stage$1.numCompleteTasks() > 0;
        } else if (((Object)((Object)TaskStatus.UNKNOWN)).equals((Object)taskStatus)) {
            bl = stage$1.numTasks() - stage$1.numFailedTasks() - stage$1.numKilledTasks() - stage$1.numActiveTasks() - stage$1.numCompleteTasks() > 0;
        } else {
            throw new MatchError((Object)taskStatus);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$stageList$2(boolean details$1, List taskStatus$1, StageData stage) {
        return details$1 && ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(taskStatus$1).asScala()).nonEmpty() ? ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskStatus$1).asScala()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$stageList$3(stage, x0$1))) : true;
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$1(String searchValueLowerCase$1, Object taskDataParams) {
        return taskDataParams.toString().toLowerCase(Locale.ROOT).contains(searchValueLowerCase$1);
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$2(Function1 containsValue$1, TaskData task) {
        boolean bl;
        Option<TaskMetrics> option = task.taskMetrics();
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            bl = BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).executorDeserializeTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).executorRunTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).jvmGcTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).resultSerializationTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).memoryBytesSpilled()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).diskBytesSpilled()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).peakExecutionMemory()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).inputMetrics().bytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).inputMetrics().recordsRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).outputMetrics().bytesWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).outputMetrics().recordsWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().fetchWaitTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().remoteBytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().localBytesRead() + ((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().remoteBytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().recordsRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().bytesWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().recordsWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().writeTime() / 1000000L)));
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$3(Function1 containsValue$1, String defaultOptionString$1, Function1 taskMetricsContainsValue$1, TaskData f) {
        return BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)f.taskId()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToInteger((int)f.index()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToInteger((int)f.attempt()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDate(f.launchTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply(f.resultFetchStart().getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultOptionString$1))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.executorId())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.host())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.status())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.taskLocality())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)f.speculative()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply(f.errorMessage().getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultOptionString$1))) || BoxesRunTime.unboxToBoolean((Object)taskMetricsContainsValue$1.apply((Object)f)) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(f.schedulerDelay()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(f.gettingResultTime())));
    }

    public static final /* synthetic */ double $anonfun$parseQuantileString$1(String s) {
        double d;
        try {
            d = new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
        }
        catch (NumberFormatException nfe) {
            throw new BadParameterException("quantiles", "double", s);
        }
        return d;
    }

    public StagesResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

