/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.workflow;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.workflow.ActionWorkflowRunner;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.w3c.dom.Node;

@Action(id="WORKFLOW", image="ui/images/workflow.svg", name="i18n::ActionWorkflow.Name", description="i18n::ActionWorkflow.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionWorkflow.keyword"}, documentationUrl="/workflow/actions/workflow.html")
public class ActionWorkflow
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWorkflow.class;
    private String filename;
    public boolean paramsFromPrevious;
    public boolean execPerRow;
    public String[] parameters;
    public String[] parameterFieldNames;
    public String[] parameterValues;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public LogLevel logFileLevel;
    public boolean parallel;
    public boolean setAppendLogfile;
    public boolean createParentFolder;
    public boolean waitingToFinish = true;
    public boolean passingAllParameters = true;
    private String runConfiguration;
    public static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.NOTHING;
    private IWorkflowEngine<WorkflowMeta> workflow;

    public ActionWorkflow(String name) {
        super(name, "");
    }

    public ActionWorkflow() {
        this("");
        this.clear();
    }

    private void allocateArgs(int nrArgs) {
    }

    private void allocateParams(int nrParameters) {
        this.parameters = new String[nrParameters];
        this.parameterFieldNames = new String[nrParameters];
        this.parameterValues = new String[nrParameters];
    }

    public Object clone() {
        ActionWorkflow je = (ActionWorkflow)super.clone();
        if (this.parameters != null) {
            int nrParameters = this.parameters.length;
            je.allocateParams(nrParameters);
            System.arraycopy(this.parameters, 0, je.parameters, 0, nrParameters);
            System.arraycopy(this.parameterFieldNames, 0, je.parameterFieldNames, 0, nrParameters);
            System.arraycopy(this.parameterValues, 0, je.parameterValues, 0, nrParameters);
        }
        return je;
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    public String getLogFilename() {
        Object retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = (String)retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = (String)retval + "." + this.logext;
            }
        }
        return retval;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(400);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfiguration));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"params_from_previous", (boolean)this.paramsFromPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XmlHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"loglevel", (String)(this.logFileLevel != null ? this.logFileLevel.getCode() : DEFAULT_LOG_LEVEL.getCode())));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wait_until_finished", (boolean)this.waitingToFinish));
        retval.append("      ").append(XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createParentFolder));
        retval.append("      ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfiguration));
        if (this.parameters != null) {
            retval.append("      ").append(XmlHandler.openTag((String)"parameters"));
            retval.append("        ").append(XmlHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (int i = 0; i < this.parameters.length; ++i) {
                retval.append("            ").append(XmlHandler.openTag((String)"parameter"));
                retval.append("            ").append(XmlHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("            ").append(XmlHandler.addTagValue((String)"stream_name", (String)this.parameterFieldNames[i]));
                retval.append("            ").append(XmlHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("            ").append(XmlHandler.closeTag((String)"parameter"));
            }
            retval.append("      ").append(XmlHandler.closeTag((String)"parameters"));
        }
        retval.append("      ").append(XmlHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.runConfiguration = XmlHandler.getTagValue((Node)entrynode, (String)"run_configuration");
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.paramsFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"params_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.setLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XmlHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XmlHandler.getTagValue((Node)entrynode, (String)"logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)XmlHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.setAppendLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            this.createParentFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"create_parent_folder"));
            this.runConfiguration = XmlHandler.getTagValue((Node)entrynode, (String)"run_configuration");
            String wait = XmlHandler.getTagValue((Node)entrynode, (String)"wait_until_finished");
            this.waitingToFinish = Utils.isEmpty((CharSequence)wait) ? true : "Y".equalsIgnoreCase(wait);
            int argnr = 0;
            while (XmlHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.allocateArgs(argnr);
            Node parametersNode = XmlHandler.getSubNode((Node)entrynode, (String)"parameters");
            String passAll = XmlHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Utils.isEmpty((CharSequence)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XmlHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.allocateParams(nrParameters);
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.parameterFieldNames[i] = XmlHandler.getTagValue((Node)knode, (String)"stream_name");
                this.parameterValues[i] = XmlHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load 'workflow' action from XML node", (Throwable)xe);
        }
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setEntryNr((long)nr);
        LogChannelFileWriter logChannelFileWriter = null;
        LogLevel jobLogLevel = this.parentWorkflow.getLogLevel();
        if (this.setLogfile) {
            String realLogFilename = this.resolve(this.getLogFilename());
            if (Utils.isEmpty((CharSequence)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionWorkflow.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (!this.createParentFolder(realLogFilename)) {
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                logChannelFileWriter = new LogChannelFileWriter(this.getLogChannelId(), HopVfs.getFileObject((String)realLogFilename), this.setAppendLogfile);
                logChannelFileWriter.startLogging();
            }
            catch (HopException e) {
                this.logError("Unable to open file appender for file [" + this.getLogFilename() + "] : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            jobLogLevel = this.logFileLevel;
        }
        try {
            if (this.parentWorkflow.getWorkflowMeta() != null) {
                this.parentWorkflow.getWorkflowMeta().setInternalHopVariables((IVariables)this);
            }
            this.logDetailed("Loading workflow from XML file : [" + this.resolve(this.filename) + "]");
            WorkflowMeta workflowMeta = this.getWorkflowMeta(this.getMetadataProvider(), (IVariables)this);
            if (workflowMeta == null) {
                throw new HopException("Unable to load the workflow: please specify a filename");
            }
            this.verifyRecursiveExecution((IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, workflowMeta);
            this.copyFrom((IVariables)this.parentWorkflow);
            this.setParentVariables((IVariables)this.parentWorkflow);
            RowMetaAndData resultRow = null;
            boolean first = true;
            ArrayList rows = new ArrayList(result.getRows());
            for (int iteration = 0; first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L; ++iteration) {
                first = false;
                if (this.execPerRow) {
                    result.getRows().clear();
                }
                resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
                NamedParameters namedParam = new NamedParameters();
                if (this.paramsFromPrevious) {
                    String[] parentParameters = this.parentWorkflow.listParameters();
                    for (int idx = 0; idx < parentParameters.length; ++idx) {
                        String par = parentParameters[idx];
                        String def = this.parentWorkflow.getParameterDefault(par);
                        String val = this.parentWorkflow.getParameterValue(par);
                        String des = this.parentWorkflow.getParameterDescription(par);
                        namedParam.addParameterDefinition(par, def, des);
                        namedParam.setParameterValue(par, val);
                    }
                }
                if (this.parameters != null) {
                    for (int idx = 0; idx < this.parameters.length; ++idx) {
                        if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                        if (Const.indexOfString((String)this.parameters[idx], (String[])namedParam.listParameters()) < 0) {
                            try {
                                namedParam.addParameterDefinition(this.parameters[idx], "", "Action runtime");
                            }
                            catch (DuplicateParamException e) {
                                this.logError("Duplicate parameter definition for " + this.parameters[idx]);
                            }
                        }
                        if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                            namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.resolve(this.parameterValues[idx]), (String)""));
                            continue;
                        }
                        String value = "";
                        if (resultRow != null) {
                            value = resultRow.getString(this.parameterFieldNames[idx], "");
                        }
                        namedParam.setParameterValue(this.parameters[idx], value);
                    }
                }
                Result oneResult = new Result();
                ArrayList<RowMetaAndData> sourceRows = null;
                if (this.execPerRow) {
                    ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                    newList.add(resultRow);
                    sourceRows = newList;
                    if (this.paramsFromPrevious && this.parameters != null) {
                        for (int idx = 0; idx < this.parameters.length; ++idx) {
                            if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                            if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.resolve(this.parameterValues[idx]), (String)""));
                                continue;
                            }
                            String fieldValue = "";
                            if (resultRow != null) {
                                fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                            }
                            namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                        }
                    }
                } else {
                    sourceRows = result.getRows();
                    if (this.paramsFromPrevious && this.parameters != null) {
                        for (int idx = 0; idx < this.parameters.length; ++idx) {
                            if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                            if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.resolve(this.parameterValues[idx]), (String)""));
                                continue;
                            }
                            String fieldValue = "";
                            if (resultRow != null) {
                                fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                            }
                            namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                        }
                    }
                }
                this.workflow = WorkflowEngineFactory.createWorkflowEngine((IVariables)this, (String)this.resolve(this.runConfiguration), (IHopMetadataProvider)this.getMetadataProvider(), (WorkflowMeta)workflowMeta, (ILoggingObject)this);
                this.workflow.setParentWorkflow(this.parentWorkflow);
                this.workflow.setLogLevel(jobLogLevel);
                this.workflow.shareWith((IVariables)this);
                this.workflow.setResult(result);
                this.workflow.setInternalHopVariables();
                this.workflow.copyParametersFromDefinitions((INamedParameterDefinitions)workflowMeta);
                this.workflow.setInteractive(this.parentWorkflow.isInteractive());
                if (this.workflow.isInteractive()) {
                    this.workflow.getActionListeners().addAll(this.parentWorkflow.getActionListeners());
                }
                this.workflow.clearParameterValues();
                String[] parameterNames = this.workflow.listParameters();
                for (int idx = 0; idx < parameterNames.length; ++idx) {
                    String parentValue;
                    String thisValue = namedParam.getParameterValue(parameterNames[idx]);
                    if (!Utils.isEmpty((CharSequence)thisValue)) {
                        this.workflow.setParameterValue(parameterNames[idx], thisValue);
                        continue;
                    }
                    if (!this.isPassingAllParameters() || Utils.isEmpty((CharSequence)(parentValue = this.parentWorkflow.getParameterValue(parameterNames[idx])))) continue;
                    this.workflow.setParameterValue(parameterNames[idx], parentValue);
                }
                this.workflow.activateParameters(this.workflow);
                this.workflow.setSourceRows(sourceRows);
                this.parentWorkflow.getWorkflowTracker().addWorkflowTracker(this.workflow.getWorkflowTracker());
                this.workflow.getWorkflowTracker().setParentWorkflowTracker(this.parentWorkflow.getWorkflowTracker());
                ActionWorkflowRunner runner = new ActionWorkflowRunner(this.workflow, result, nr, this.log);
                Thread workflowRunnerThread = new Thread(runner);
                workflowRunnerThread.setName(Const.NVL((String)this.workflow.getWorkflowMeta().getName(), (String)this.workflow.getWorkflowMeta().getFilename()) + " UUID: " + UUID.randomUUID().toString());
                workflowRunnerThread.start();
                if (!this.isWaitingToFinish()) continue;
                while (!runner.isFinished() && !this.parentWorkflow.isStopped()) {
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.parentWorkflow.isStopped()) {
                    this.workflow.stopExecution();
                    runner.waitUntilFinished();
                }
                oneResult = runner.getResult();
                result.clear();
                result.add(oneResult);
                if (!Utils.isEmpty((List)oneResult.getRows())) {
                    result.setRows(new ArrayList(oneResult.getRows()));
                }
                if (oneResult.getResult()) continue;
                result.setNrErrors(result.getNrErrors() + 1L);
            }
        }
        catch (HopException ke) {
            this.logError("Error running action 'workflow' : ", ke);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        if (this.setLogfile && logChannelFileWriter != null) {
            logChannelFileWriter.stopLogging();
            ResultFile resultFile = new ResultFile(1, logChannelFileWriter.getLogFile(), this.parentWorkflow.getWorkflowName(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (logChannelFileWriter.getException() != null) {
                this.logError("Unable to open log file [" + this.getLogFilename() + "] : ");
                this.logError(Const.getStackTracker((Throwable)logChannelFileWriter.getException()));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean resultat = true;
        try {
            parentfolder = HopVfs.getFileObject((String)filename).getParent();
            if (!parentfolder.exists()) {
                if (this.createParentFolder) {
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderCreated", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                } else {
                    this.log.logError(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    resultat = false;
                }
            } else if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
            }
        }
        catch (Exception e) {
            resultat = false;
            this.log.logError(BaseMessages.getString(PKG, (String)"ActionWorkflow.Error.ChekingParentLogFolderTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionWorkflow.Error.ChekingParentLogFolder", (String[])new String[]{parentfolder.getName().toString()}), e});
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                    parentfolder = null;
                }
                catch (Exception exception) {}
            }
        }
        return resultat;
    }

    private void verifyRecursiveExecution(IWorkflowEngine<WorkflowMeta> parentWorkflow, WorkflowMeta workflowMeta) throws HopException {
        if (parentWorkflow == null) {
            return;
        }
        WorkflowMeta parentWorkflowMeta = parentWorkflow.getWorkflowMeta();
        if (parentWorkflowMeta.getName() == null && workflowMeta.getName() != null) {
            return;
        }
        if (parentWorkflowMeta.getName() != null && workflowMeta.getName() == null) {
            return;
        }
        if (workflowMeta.getFilename() != null && workflowMeta.getFilename().equals(parentWorkflowMeta.getFilename())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionWorkflowError.Recursive", (String[])new String[]{workflowMeta.getFilename()}));
        }
        this.verifyRecursiveExecution((IWorkflowEngine<WorkflowMeta>)parentWorkflow.getParentWorkflow(), workflowMeta);
    }

    public void clear() {
        super.clear();
        this.filename = null;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.setAppendLogfile = false;
        this.runConfiguration = null;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<SqlStatement> getSqlStatements(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        this.copyFrom(variables);
        WorkflowMeta workflowMeta = this.getWorkflowMeta(metadataProvider, variables);
        return workflowMeta.getSqlStatements(metadataProvider, null, variables);
    }

    public WorkflowMeta getWorkflowMeta(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        WorkflowMeta workflowMeta = null;
        try {
            CurrentDirectoryResolver r = new CurrentDirectoryResolver();
            IVariables tmpSpace = r.resolveCurrentDirectory(variables, this.parentWorkflow, this.getFilename());
            String realFilename = tmpSpace.resolve(this.getFilename());
            workflowMeta = new WorkflowMeta(tmpSpace, realFilename, metadataProvider);
            if (workflowMeta != null) {
                workflowMeta.setMetadataProvider(metadataProvider);
            }
            return workflowMeta;
        }
        catch (Exception e) {
            throw new HopException("Unexpected error during workflow metadata load", (Throwable)e);
        }
    }

    public boolean isExecPerRow() {
        return this.execPerRow;
    }

    public void setExecPerRow(boolean runEveryResultRow) {
        this.execPerRow = runEveryResultRow;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = this.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        this.copyFrom(variables);
        WorkflowMeta workflowMeta = this.getWorkflowMeta(metadataProvider, variables);
        String proposedNewFilename = workflowMeta.exportResources((IVariables)this, definitions, namingInterface, metadataProvider);
        String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
        workflowMeta.setFilename(newFilename);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.setLogfile) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "logfile", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
    }

    protected String getLogfile() {
        return this.logfile;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }

    public IWorkflowEngine<WorkflowMeta> getWorkflow() {
        return this.workflow;
    }

    private boolean isWorkflowDefined() {
        return !Utils.isEmpty((CharSequence)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isWorkflowDefined()};
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"ActionWorkflow.ReferencedObject.Description", (String[])new String[0])};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return this.getWorkflowMeta(metadataProvider, variables);
    }
}

