/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingElementsHandler;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;

public class KeyedBufferingElementsHandler
implements BufferingElementsHandler {
    private final KeyedStateBackend<Object> backend;
    private final String stateName;
    private final ListState<BufferedElement> state;

    static KeyedBufferingElementsHandler create(KeyedStateBackend backend, ListStateDescriptor<BufferedElement> stateDescriptor) throws Exception {
        return new KeyedBufferingElementsHandler((KeyedStateBackend<Object>)backend, stateDescriptor);
    }

    private KeyedBufferingElementsHandler(KeyedStateBackend<Object> backend, ListStateDescriptor<BufferedElement> stateDescriptor) throws Exception {
        this.backend = backend;
        this.stateName = stateDescriptor.getName();
        this.state = (ListState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, stateDescriptor);
    }

    @Override
    public void buffer(BufferedElement element) {
        try {
            this.state.add((Object)element);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to buffer element in state backend." + element, e);
        }
    }

    @Override
    public Stream<BufferedElement> getElements() {
        return this.backend.getKeys(this.stateName, (Object)VoidNamespace.INSTANCE).flatMap(key -> {
            try {
                this.backend.setCurrentKey(key);
                return StreamSupport.stream(((Iterable)this.state.get()).spliterator(), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve buffered element from state backend.", e);
            }
        });
    }

    @Override
    public void clear() {
        List keys = this.backend.getKeys(this.stateName, (Object)VoidNamespace.INSTANCE).collect(Collectors.toList());
        try {
            for (Object key : keys) {
                this.backend.setCurrentKey(key);
                this.state.clear();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear buffered element state", e);
        }
    }
}

