/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import org.apache.beam.runners.flink.translation.types.EncodedValueTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;

public class KvKeySelector<InputT, K>
implements KeySelector<WindowedValue<KV<K, InputT>>, byte[]>,
ResultTypeQueryable<byte[]> {
    private final Coder<K> keyCoder;

    public KvKeySelector(Coder<K> keyCoder) {
        this.keyCoder = keyCoder;
    }

    public byte[] getKey(WindowedValue<KV<K, InputT>> value) throws Exception {
        return CoderUtils.encodeToByteArray(this.keyCoder, (Object)((KV)value.getValue()).getKey());
    }

    public TypeInformation<byte[]> getProducedType() {
        return new EncodedValueTypeInformation();
    }
}

