/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.joda.time.Instant;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.reflect.ClassTag;

public class BoundedDatasetFactory {
    private BoundedDatasetFactory() {
    }

    public static <T> Dataset<WindowedValue<T>> createDatasetFromRows(SparkSession session, BoundedSource<T> source, SerializablePipelineOptions options, Encoder<WindowedValue<T>> encoder) {
        Params<T> params = new Params<T>(encoder, options, session.sparkContext().defaultParallelism());
        BeamTable<T> table = new BeamTable<T>(source, params);
        DataSourceV2Relation logicalPlan = DataSourceV2Relation.create(table, (Option)Option.empty(), (Option)Option.empty());
        return Dataset.ofRows((SparkSession)session, (LogicalPlan)logicalPlan).as(encoder);
    }

    public static <T> Dataset<WindowedValue<T>> createDatasetFromRDD(SparkSession session, BoundedSource<T> source, SerializablePipelineOptions options, Encoder<WindowedValue<T>> encoder) {
        Params<T> params = new Params<T>(encoder, options, session.sparkContext().defaultParallelism());
        BoundedRDD<T> rdd = new BoundedRDD<T>(session.sparkContext(), source, params);
        return session.createDataset(rdd, encoder);
    }

    private static class Params<T>
    implements Serializable {
        final Encoder<WindowedValue<T>> encoder;
        final SerializablePipelineOptions options;
        final int numPartitions;

        Params(Encoder<WindowedValue<T>> encoder, SerializablePipelineOptions options, int numPartitions) {
            Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be greater than zero.");
            this.encoder = encoder;
            this.options = options;
            this.numPartitions = numPartitions;
        }
    }

    private static class SourcePartitionIterator<T>
    extends AbstractIterator<WindowedValue<T>>
    implements Closeable {
        BoundedSource.BoundedReader<T> reader;
        boolean started = false;

        public SourcePartitionIterator(SourcePartition<T> partition, Params<T> params) {
            try {
                this.reader = partition.source.createReader(params.options.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create reader from a BoundedSource.", e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.endOfData();
                try {
                    this.reader.close();
                }
                finally {
                    this.reader = null;
                }
            }
        }

        protected WindowedValue<T> computeNext() {
            try {
                if (this.started ? this.reader.advance() : this.start()) {
                    return WindowedValue.timestampedValueInGlobalWindow((Object)this.reader.getCurrent(), (Instant)this.reader.getCurrentTimestamp());
                }
                this.close();
                return (WindowedValue)this.endOfData();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to start or advance reader.", e);
            }
        }

        private boolean start() throws IOException {
            this.started = true;
            return this.reader.start();
        }
    }

    private static class SourcePartition<T>
    implements Partition,
    InputPartition {
        final BoundedSource<T> source;
        final int index;

        SourcePartition(BoundedSource<T> source, IntSupplier idxSupplier) {
            this.source = source;
            this.index = idxSupplier.getAsInt();
        }

        static <T> List<SourcePartition<T>> partitionsOf(BoundedSource<T> source, Params<T> params) {
            try {
                PipelineOptions options = params.options.get();
                long desiredSize = source.getEstimatedSizeBytes(options) / (long)params.numPartitions;
                List split = source.split(desiredSize, options);
                IntSupplier idxSupplier = new AtomicInteger(0)::getAndIncrement;
                return split.stream().map(s -> new SourcePartition(s, idxSupplier)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException("Error splitting BoundedSource " + source.getClass().getCanonicalName(), e);
            }
        }

        public int index() {
            return this.index;
        }

        public int hashCode() {
            return this.index;
        }
    }

    private static class BeamTable<T>
    implements Table,
    SupportsRead {
        final BoundedSource<T> source;
        final Params<T> params;

        BeamTable(BoundedSource<T> source, Params<T> params) {
            this.source = source;
            this.params = params;
        }

        public Encoder<WindowedValue<T>> getEncoder() {
            return this.params.encoder;
        }

        public ScanBuilder newScanBuilder(CaseInsensitiveStringMap ignored) {
            return () -> new Scan(){

                public StructType readSchema() {
                    return params.encoder.schema();
                }

                public Batch toBatch() {
                    return new BeamBatch(source, params);
                }
            };
        }

        public String name() {
            return "BeamSource<" + this.source.getClass().getName() + ">";
        }

        public StructType schema() {
            return this.params.encoder.schema();
        }

        public Set<TableCapability> capabilities() {
            return ImmutableSet.of((Object)TableCapability.BATCH_READ);
        }

        private static class BeamPartitionReader<T>
        implements PartitionReader<InternalRow> {
            final SourcePartitionIterator<T> iterator;
            final ExpressionEncoder.Serializer<WindowedValue<T>> serializer;
            @Nullable
            transient InternalRow next;

            BeamPartitionReader(SourcePartition<T> partition, Params<T> params) {
                this.iterator = new SourcePartitionIterator<T>(partition, params);
                this.serializer = ((ExpressionEncoder)params.encoder).createSerializer();
            }

            public boolean next() throws IOException {
                if (this.iterator.hasNext()) {
                    this.next = this.serializer.apply((Object)((WindowedValue)this.iterator.next()));
                    return true;
                }
                return false;
            }

            public InternalRow get() {
                if (this.next == null) {
                    throw new IllegalStateException("Next not available");
                }
                return this.next;
            }

            public void close() throws IOException {
                this.next = null;
                this.iterator.close();
            }
        }

        private static class BeamBatch<T>
        implements Batch,
        Serializable {
            final BoundedSource<T> source;
            final Params<T> params;

            private BeamBatch(BoundedSource<T> source, Params<T> params) {
                this.source = source;
                this.params = params;
            }

            public InputPartition[] planInputPartitions() {
                return SourcePartition.partitionsOf(this.source, this.params).toArray(new InputPartition[0]);
            }

            public PartitionReaderFactory createReaderFactory() {
                return (PartitionReaderFactory & Serializable)p -> new BeamPartitionReader((SourcePartition)p, this.params);
            }
        }
    }

    private static class BoundedRDD<T>
    extends RDD<WindowedValue<T>> {
        final BoundedSource<T> source;
        final Params<T> params;

        public BoundedRDD(SparkContext sc, BoundedSource<T> source, Params<T> params) {
            super(sc, ScalaInterop.emptyList(), ClassTag.apply(WindowedValue.class));
            this.source = source;
            this.params = params;
        }

        public Iterator<WindowedValue<T>> compute(Partition split, TaskContext context) {
            return new InterruptibleIterator(context, JavaConverters.asScalaIterator(new SourcePartitionIterator<T>((SourcePartition)split, this.params)));
        }

        public Partition[] getPartitions() {
            return SourcePartition.partitionsOf(this.source, this.params).toArray(new Partition[0]);
        }
    }
}

