/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.beam.runners.spark.metrics.BeamMetricSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;

public class WithMetricsSupport
extends MetricRegistry {
    private final MetricRegistry internalMetricRegistry;

    private WithMetricsSupport(MetricRegistry internalMetricRegistry) {
        this.internalMetricRegistry = internalMetricRegistry;
    }

    public static WithMetricsSupport forRegistry(MetricRegistry metricRegistry) {
        return new WithMetricsSupport(metricRegistry);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.internalMetricRegistry.getTimers(filter);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.internalMetricRegistry.getMeters(filter);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.internalMetricRegistry.getHistograms(filter);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.internalMetricRegistry.getCounters(filter);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder((Comparator)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER));
        SortedMap gauges = this.internalMetricRegistry.getGauges((n, m) -> filter.matches(n, m) || m instanceof BeamMetricSet);
        for (Map.Entry entry : gauges.entrySet()) {
            Gauge gauge = (Gauge)entry.getValue();
            if (gauge instanceof BeamMetricSet) {
                builder.putAll(((BeamMetricSet)gauge).getValue((String)entry.getKey(), filter));
                continue;
            }
            builder.put((Object)((String)entry.getKey()), (Object)gauge);
        }
        return builder.build();
    }
}

