/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.data;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.json.simple.JSONObject;

public class GraphPropertyData {
    protected String id;
    protected Object value;
    protected GraphPropertyDataType type;
    protected boolean primary;

    public GraphPropertyData() {
    }

    public GraphPropertyData(String id, Object value, GraphPropertyDataType type, boolean primary) {
        this.id = id;
        this.value = value;
        this.type = type;
        this.primary = primary;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        switch (this.type) {
            case Boolean: {
                return (Boolean)this.value != false ? "true" : "false";
            }
            case String: {
                return GraphPropertyData.escapeString((String)this.value);
            }
        }
        return this.value.toString();
    }

    public static String escapeString(String string) {
        if (string.contains("\"")) {
            string = string.replace("\"", "\"\"");
        }
        if (string.contains("\\")) {
            string = string.replace("\\", "\\\\");
        }
        return string;
    }

    public Object toJson() {
        JSONObject jProperty = new JSONObject();
        jProperty.put((Object)"id", (Object)this.id);
        if (this.type != null) {
            jProperty.put((Object)"type", (Object)this.type.name());
        }
        if (this.value != null) {
            jProperty.put((Object)"value", this.value);
        }
        if (this.primary) {
            jProperty.put((Object)"primary", (Object)this.primary);
        }
        return jProperty;
    }

    public GraphPropertyData(JSONObject jProperty) {
        this();
        this.id = (String)jProperty.get((Object)"id");
        String typeCode = (String)jProperty.get((Object)"type");
        if (StringUtils.isNotEmpty((String)typeCode)) {
            this.type = GraphPropertyDataType.parseCode(typeCode);
        }
        this.value = jProperty.get((Object)"value");
        Object primaryValue = jProperty.get((Object)"primary");
        this.primary = primaryValue != null && (Boolean)primaryValue != false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public GraphPropertyDataType getType() {
        return this.type;
    }

    public void setType(GraphPropertyDataType type) {
        this.type = type;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }
}

