/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator;

import java.util.ArrayList;
import java.util.Base64;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileNotFoundException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.calculator.CalculatorData;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMeta;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMetaFunction;
import org.apache.hop.pipeline.transforms.calculator.CalculatorValueDataUtil;

public class Calculator
extends BaseTransform<CalculatorMeta, CalculatorData> {
    private static final Class<?> PKG = CalculatorMeta.class;

    public Calculator(TransformMeta transformMeta, CalculatorMeta meta, CalculatorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            ((CalculatorData)this.data).clearValuesMetaMapping();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((CalculatorData)this.data).setOutputRowMeta(this.getInputRowMeta().clone());
            ((CalculatorMeta)this.meta).getFields(((CalculatorData)this.data).getOutputRowMeta(), this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((CalculatorData)this.data).setCalcRowMeta(((CalculatorMeta)this.meta).getAllFields(this.getInputRowMeta()));
            ((CalculatorData)this.data).setFieldIndexes(new FieldIndexes[((CalculatorMeta)this.meta).getFunctions().size()]);
            ArrayList<Integer> tempIndexes = new ArrayList<Integer>();
            for (i = 0; i < ((CalculatorMeta)this.meta).getFunctions().size(); ++i) {
                CalculatorMetaFunction function = ((CalculatorMeta)this.meta).getFunctions().get(i);
                ((CalculatorData)this.data).getFieldIndexes()[i] = new FieldIndexes();
                if (!Utils.isEmpty((CharSequence)function.getFieldName())) {
                    ((CalculatorData)this.data).getFieldIndexes()[i].indexName = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldName());
                    if (((CalculatorData)this.data).getFieldIndexes()[i].indexName < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Calculator.Error.UnableFindField", (String[])new String[]{function.getFieldName(), "" + (i + 1)}));
                    }
                } else {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"Calculator.Error.NoNameField", (String[])new String[]{"" + (i + 1)}));
                }
                if (!Utils.isEmpty((CharSequence)function.getFieldA())) {
                    if (function.getCalcType() != CalculatorMetaFunction.CalculationType.CONSTANT) {
                        ((CalculatorData)this.data).getFieldIndexes()[i].indexA = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldA());
                        if (((CalculatorData)this.data).getFieldIndexes()[i].indexA < 0) {
                            throw new HopTransformException("Unable to find the first argument field '" + function.getFieldName() + " for calculation #" + (i + 1));
                        }
                    } else {
                        ((CalculatorData)this.data).getFieldIndexes()[i].indexA = -1;
                    }
                } else {
                    throw new HopTransformException("There is no first argument specified for calculated field #" + (i + 1));
                }
                if (!Utils.isEmpty((CharSequence)function.getFieldB())) {
                    ((CalculatorData)this.data).getFieldIndexes()[i].indexB = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldB());
                    if (((CalculatorData)this.data).getFieldIndexes()[i].indexB < 0) {
                        throw new HopTransformException("Unable to find the second argument field '" + function.getFieldName() + " for calculation #" + (i + 1));
                    }
                }
                ((CalculatorData)this.data).getFieldIndexes()[i].indexC = -1;
                if (!Utils.isEmpty((CharSequence)function.getFieldC())) {
                    ((CalculatorData)this.data).getFieldIndexes()[i].indexC = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldC());
                    if (((CalculatorData)this.data).getFieldIndexes()[i].indexC < 0) {
                        throw new HopTransformException("Unable to find the third argument field '" + function.getFieldName() + " for calculation #" + (i + 1));
                    }
                }
                if (!function.isRemovedFromResult()) continue;
                tempIndexes.add(this.getInputRowMeta().size() + i);
            }
            ((CalculatorData)this.data).setTempIndexes(new int[tempIndexes.size()]);
            for (i = 0; i < ((CalculatorData)this.data).getTempIndexes().length; ++i) {
                ((CalculatorData)this.data).getTempIndexes()[i] = (Integer)tempIndexes.get(i);
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"Calculator.Log.ReadRow", (String[])new String[0]) + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] row = this.calcFields(this.getInputRowMeta(), r);
            this.putRow(((CalculatorData)this.data).getOutputRowMeta(), row);
            if (this.log.isRowLevel()) {
                this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"Calculator.Log.Linenr", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (HopFileNotFoundException e) {
            if (((CalculatorMeta)this.meta).isFailIfNoFile()) {
                this.logError(BaseMessages.getString(PKG, (String)"Calculator.Log.NoFile", (String[])new String[0]) + " : " + e.getFilepath());
                this.setErrors(this.getErrors() + 1L);
                return false;
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)("Calculator.ErrorInTransformRunning : " + e.getMessage()), (String[])new String[0]));
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"Calculator.ErrorInTransformRunning", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private Object[] calcFields(IRowMeta inputRowMeta, Object[] r) throws HopValueException, HopFileNotFoundException {
        Object[] calcData = RowDataUtil.resizeArray((Object[])r, (int)((CalculatorData)this.data).getCalcRowMeta().size());
        int i = 0;
        int index = inputRowMeta.size() + i;
        while (i < ((CalculatorMeta)this.meta).getFunctions().size()) {
            CalculatorMetaFunction fn = ((CalculatorMeta)this.meta).getFunctions().get(i);
            if (!Utils.isEmpty((CharSequence)fn.getFieldName())) {
                IValueMeta targetMeta = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(index);
                IValueMeta metaA = null;
                Object dataA = null;
                if (((CalculatorData)this.data).getFieldIndexes()[i].indexA >= 0) {
                    metaA = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(((CalculatorData)this.data).getFieldIndexes()[i].indexA);
                    dataA = calcData[((CalculatorData)this.data).getFieldIndexes()[i].indexA];
                }
                IValueMeta metaB = null;
                Object dataB = null;
                if (((CalculatorData)this.data).getFieldIndexes()[i].indexB >= 0) {
                    metaB = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(((CalculatorData)this.data).getFieldIndexes()[i].indexB);
                    dataB = calcData[((CalculatorData)this.data).getFieldIndexes()[i].indexB];
                }
                IValueMeta metaC = null;
                Object dataC = null;
                if (((CalculatorData)this.data).getFieldIndexes()[i].indexC >= 0) {
                    metaC = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(((CalculatorData)this.data).getFieldIndexes()[i].indexC);
                    dataC = calcData[((CalculatorData)this.data).getFieldIndexes()[i].indexC];
                }
                CalculatorMetaFunction.CalculationType calcType = fn.getCalcType();
                int resultType = metaA != null ? metaA.getType() : 0;
                switch (calcType) {
                    case NONE: {
                        break;
                    }
                    case COPY_OF_FIELD: {
                        calcData[index] = dataA;
                        break;
                    }
                    case ADD: {
                        calcData[index] = ValueDataUtil.plus((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        if (!metaA.isString() && !metaB.isString()) break;
                        resultType = 2;
                        break;
                    }
                    case SUBTRACT: {
                        calcData[index] = ValueDataUtil.minus((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        if (!metaA.isDate()) break;
                        resultType = 5;
                        break;
                    }
                    case MULTIPLY: {
                        calcData[index] = ValueDataUtil.multiply((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        if (!metaA.isString() && !metaB.isString()) break;
                        resultType = 2;
                        break;
                    }
                    case DIVIDE: {
                        calcData[index] = ValueDataUtil.divide((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case SQUARE: {
                        calcData[index] = ValueDataUtil.multiply((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case SQUARE_ROOT: {
                        calcData[index] = ValueDataUtil.sqrt((IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case PERCENT_1: {
                        calcData[index] = ValueDataUtil.percent1((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case PERCENT_2: {
                        calcData[index] = ValueDataUtil.percent2((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case PERCENT_3: {
                        calcData[index] = ValueDataUtil.percent3((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case COMBINATION_1: {
                        calcData[index] = ValueDataUtil.combination1((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (IValueMeta)metaC, dataC);
                        break;
                    }
                    case COMBINATION_2: {
                        calcData[index] = ValueDataUtil.combination2((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case ROUND_1: {
                        calcData[index] = ValueDataUtil.round((IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case ROUND_2: {
                        calcData[index] = ValueDataUtil.round((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case ROUND_CUSTOM_1: {
                        calcData[index] = ValueDataUtil.round((IValueMeta)metaA, (Object)dataA, (int)metaB.getNumber(dataB).intValue());
                        break;
                    }
                    case ROUND_CUSTOM_2: {
                        calcData[index] = ValueDataUtil.round((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (int)metaC.getNumber(dataC).intValue());
                        break;
                    }
                    case ROUND_STD_1: {
                        calcData[index] = ValueDataUtil.round((IValueMeta)metaA, (Object)dataA, (int)4);
                        break;
                    }
                    case ROUND_STD_2: {
                        calcData[index] = ValueDataUtil.round((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (int)4);
                        break;
                    }
                    case CEIL: {
                        calcData[index] = ValueDataUtil.ceil((IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case FLOOR: {
                        calcData[index] = ValueDataUtil.floor((IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case CONSTANT: {
                        calcData[index] = fn.getFieldA();
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case NVL: {
                        calcData[index] = ValueDataUtil.nvl((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        break;
                    }
                    case ADD_DAYS: {
                        calcData[index] = ValueDataUtil.addDays((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADD_HOURS: {
                        calcData[index] = ValueDataUtil.addHours((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADD_MINUTES: {
                        calcData[index] = ValueDataUtil.addMinutes((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case YEAR_OF_DATE: {
                        calcData[index] = ValueDataUtil.yearOfDate((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case MONTH_OF_DATE: {
                        calcData[index] = ValueDataUtil.monthOfDate((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DAY_OF_YEAR: {
                        calcData[index] = ValueDataUtil.dayOfYear((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DAY_OF_MONTH: {
                        calcData[index] = ValueDataUtil.dayOfMonth((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DAY_OF_WEEK: {
                        calcData[index] = ValueDataUtil.dayOfWeek((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case WEEK_OF_YEAR: {
                        calcData[index] = ValueDataUtil.weekOfYear((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case WEEK_OF_YEAR_ISO8601: {
                        calcData[index] = ValueDataUtil.weekOfYearISO8601((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case YEAR_OF_DATE_ISO8601: {
                        calcData[index] = ValueDataUtil.yearOfDateISO8601((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case BYTE_TO_HEX_ENCODE: {
                        calcData[index] = ValueDataUtil.byteToHexEncode((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case HEX_TO_BYTE_DECODE: {
                        calcData[index] = ValueDataUtil.hexToByteDecode((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case CHAR_TO_HEX_ENCODE: {
                        calcData[index] = ValueDataUtil.charToHexEncode((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case HEX_TO_CHAR_DECODE: {
                        calcData[index] = ValueDataUtil.hexToCharDecode((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case CRC32: {
                        calcData[index] = ValueDataUtil.checksumCRC32((IValueMeta)metaA, (Object)dataA, (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADLER32: {
                        calcData[index] = ValueDataUtil.checksumAdler32((IValueMeta)metaA, (Object)dataA, (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case MD5: {
                        calcData[index] = ValueDataUtil.createChecksum((IValueMeta)metaA, (Object)dataA, (String)"MD5", (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case SHA1: {
                        calcData[index] = ValueDataUtil.createChecksum((IValueMeta)metaA, (Object)dataA, (String)"SHA-1", (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case LEVENSHTEIN_DISTANCE: {
                        calcData[index] = ValueDataUtil.getLevenshtein_Distance((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case METAPHONE: {
                        calcData[index] = ValueDataUtil.get_Metaphone((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DOUBLE_METAPHONE: {
                        calcData[index] = ValueDataUtil.get_Double_Metaphone((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ABS: {
                        calcData[index] = ValueDataUtil.abs((IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case REMOVE_TIME_FROM_DATE: {
                        calcData[index] = ValueDataUtil.removeTimeFromDate((IValueMeta)metaA, (Object)dataA);
                        break;
                    }
                    case DATE_DIFF: {
                        calcData[index] = ValueDataUtil.DateDiff((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (String)"d");
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADD3: {
                        calcData[index] = ValueDataUtil.plus3((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (IValueMeta)metaC, dataC);
                        if (!metaA.isString() && !metaB.isString() && !metaC.isString()) break;
                        resultType = 2;
                        break;
                    }
                    case INITCAP: {
                        calcData[index] = ValueDataUtil.initCap((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case UPPER_CASE: {
                        calcData[index] = ValueDataUtil.upperCase((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case LOWER_CASE: {
                        calcData[index] = ValueDataUtil.lowerCase((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case MASK_XML: {
                        calcData[index] = ValueDataUtil.escapeXml((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case USE_CDATA: {
                        calcData[index] = ValueDataUtil.useCDATA((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REMOVE_CR: {
                        calcData[index] = ValueDataUtil.removeCR((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REMOVE_LF: {
                        calcData[index] = ValueDataUtil.removeLF((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REMOVE_CRLF: {
                        calcData[index] = ValueDataUtil.removeCRLF((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REMOVE_TAB: {
                        calcData[index] = ValueDataUtil.removeTAB((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case GET_ONLY_DIGITS: {
                        calcData[index] = ValueDataUtil.getDigits((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REMOVE_DIGITS: {
                        calcData[index] = ValueDataUtil.removeDigits((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case STRING_LEN: {
                        calcData[index] = ValueDataUtil.stringLen((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case LOAD_FILE_CONTENT_BINARY: {
                        calcData[index] = ValueDataUtil.loadFileContentInBinary((IValueMeta)metaA, (Object)dataA, (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADD_TIME_TO_DATE: {
                        calcData[index] = ValueDataUtil.addTimeToDate((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (IValueMeta)metaC, dataC);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case QUARTER_OF_DATE: {
                        calcData[index] = ValueDataUtil.quarterOfDate((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case SUBSTITUTE_VARIABLE: {
                        calcData[index] = this.resolve(dataA.toString());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case UNESCAPE_XML: {
                        calcData[index] = ValueDataUtil.unEscapeXml((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ESCAPE_HTML: {
                        calcData[index] = ValueDataUtil.escapeHtml((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case UNESCAPE_HTML: {
                        calcData[index] = ValueDataUtil.unEscapeHtml((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ESCAPE_SQL: {
                        calcData[index] = ValueDataUtil.escapeSql((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DATE_WORKING_DIFF: {
                        calcData[index] = ValueDataUtil.DateWorkingDiff((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADD_MONTHS: {
                        calcData[index] = ValueDataUtil.addMonths((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case CHECK_XML_FILE_WELL_FORMED: {
                        calcData[index] = ValueDataUtil.isXmlFileWellFormed((IValueMeta)metaA, (Object)dataA, (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case CHECK_XML_WELL_FORMED: {
                        calcData[index] = ValueDataUtil.isXmlWellFormed((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case GET_FILE_ENCODING: {
                        calcData[index] = ValueDataUtil.getFileEncoding((IValueMeta)metaA, (Object)dataA, (boolean)((CalculatorMeta)this.meta).isFailIfNoFile());
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DAMERAU_LEVENSHTEIN: {
                        calcData[index] = ValueDataUtil.getDamerauLevenshtein_Distance((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case NEEDLEMAN_WUNSH: {
                        calcData[index] = CalculatorValueDataUtil.getNeedlemanWunschDistance(dataA, dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case JARO: {
                        calcData[index] = ValueDataUtil.getJaro_Similitude((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case JARO_WINKLER: {
                        calcData[index] = ValueDataUtil.getJaroWinkler_Similitude((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case SOUNDEX: {
                        calcData[index] = ValueDataUtil.get_SoundEx((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REFINED_SOUNDEX: {
                        calcData[index] = ValueDataUtil.get_RefinedSoundEx((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DATE_DIFF_MSEC: {
                        calcData[index] = ValueDataUtil.DateDiff((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (String)"ms");
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DATE_DIFF_SEC: {
                        calcData[index] = ValueDataUtil.DateDiff((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (String)"s");
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DATE_DIFF_MN: {
                        calcData[index] = ValueDataUtil.DateDiff((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (String)"mn");
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case DATE_DIFF_HR: {
                        calcData[index] = ValueDataUtil.DateDiff((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB, (String)"h");
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case HOUR_OF_DAY: {
                        calcData[index] = ValueDataUtil.hourOfDay((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case MINUTE_OF_HOUR: {
                        calcData[index] = ValueDataUtil.minuteOfHour((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case SECOND_OF_MINUTE: {
                        calcData[index] = ValueDataUtil.secondOfMinute((IValueMeta)metaA, (Object)dataA);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case ADD_SECONDS: {
                        calcData[index] = ValueDataUtil.addSeconds((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = calcType.getDefaultResultType();
                        break;
                    }
                    case REMAINDER: {
                        if (targetMeta.getType() != metaA.getType() || targetMeta.getType() != metaB.getType()) {
                            dataA = targetMeta.convertData(metaA, dataA);
                            metaA = targetMeta.clone();
                            dataB = targetMeta.convertData(metaB, dataB);
                            metaB = targetMeta.clone();
                        }
                        calcData[index] = ValueDataUtil.remainder((IValueMeta)metaA, (Object)dataA, (IValueMeta)metaB, (Object)dataB);
                        resultType = targetMeta.getType();
                        break;
                    }
                    case BASE64_ENCODE: {
                        calcData[index] = dataA != null ? Base64.getEncoder().withoutPadding().encodeToString(dataA.toString().getBytes()) : null;
                        resultType = 2;
                        break;
                    }
                    case BASE64_DECODE: {
                        if (dataA != null) {
                            byte[] tmpDecoded = Base64.getDecoder().decode(dataA.toString());
                            String tmpDecodedString = new String(tmpDecoded);
                            calcData[index] = targetMeta.convertData(metaA, (Object)tmpDecodedString);
                        } else {
                            calcData[index] = null;
                        }
                        resultType = targetMeta.getType();
                        break;
                    }
                    default: {
                        throw new HopValueException(BaseMessages.getString(PKG, (String)"Calculator.Log.UnknownCalculationType", (String[])new String[0]) + fn.getCalcType());
                    }
                }
                if (targetMeta.getType() == 0) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"Calculator.Log.NoType", (String[])new String[0]) + (i + 1) + " : " + fn.getFieldName() + " = " + fn.getCalcType().getCode() + " / " + fn.getCalcType().getDescription());
                }
                if (calcData[index] != null && targetMeta.getType() != resultType) {
                    IValueMeta resultMeta;
                    try {
                        resultMeta = ((CalculatorData)this.data).getValueMetaFor(resultType, "result");
                    }
                    catch (Exception exception) {
                        throw new HopValueException("Error creating value");
                    }
                    resultMeta.setConversionMask(fn.getConversionMask());
                    resultMeta.setGroupingSymbol(fn.getGroupingSymbol());
                    resultMeta.setDecimalSymbol(fn.getDecimalSymbol());
                    resultMeta.setCurrencySymbol(fn.getCurrencySymbol());
                    try {
                        calcData[index] = targetMeta.convertData(resultMeta, calcData[index]);
                    }
                    catch (Exception ex) {
                        throw new HopValueException("resultType: " + resultType + "; targetMeta: " + targetMeta.getType(), (Throwable)ex);
                    }
                }
            }
            ++i;
            ++index;
        }
        return RowDataUtil.removeItems((Object[])calcData, (int[])((CalculatorData)this.data).getTempIndexes());
    }

    public class FieldIndexes {
        public int indexName;
        public int indexA;
        public int indexB;
        public int indexC;
    }
}

