/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.kerberos.codec.encryptionKey.EncryptionKeyContainer;
import org.apache.directory.shared.kerberos.codec.principalName.PrincipalNameContainer;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;

public class KerberosDecoder {
    public static EncryptionKey decodeEncryptionKey(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        EncryptionKeyContainer encryptionKeyContainer = new EncryptionKeyContainer();
        try {
            Asn1Decoder.decode(stream, encryptionKeyContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return encryptionKeyContainer.getEncryptionKey();
    }

    public static PrincipalName decodePrincipalName(byte[] data) throws KerberosException {
        ByteBuffer stream = ByteBuffer.allocate(data.length);
        stream.put(data);
        stream.flip();
        PrincipalNameContainer principalNameContainer = new PrincipalNameContainer();
        try {
            Asn1Decoder.decode(stream, principalNameContainer);
        }
        catch (DecoderException de) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)de);
        }
        return principalNameContainer.getPrincipalName();
    }
}

