/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUtil;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.Format;
import org.apache.datasketches.cpc.PreambleUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    static final short defaultSeedHash = ThetaUtil.computeSeedHash((long)9001L);

    private static void checkFirst8(WritableMemory wmem, Format format, int lgK, int fiCol) {
        Assert.assertEquals((Object)PreambleUtil.getFormat((Memory)wmem), (Object)format);
        Assert.assertEquals((int)PreambleUtil.getPreInts((Memory)wmem), (int)PreambleUtil.getDefinedPreInts((Format)format));
        Assert.assertEquals((int)PreambleUtil.getSerVer((Memory)wmem), (int)1);
        Assert.assertEquals((Object)PreambleUtil.getFamily((Memory)wmem), (Object)Family.CPC);
        Assert.assertEquals((int)PreambleUtil.getLgK((Memory)wmem), (int)lgK);
        Assert.assertEquals((int)PreambleUtil.getFiCol((Memory)wmem), (int)fiCol);
        Assert.assertEquals((int)PreambleUtil.getFlags((Memory)wmem), (int)(format.ordinal() << 2 | 2));
        Assert.assertEquals((short)PreambleUtil.getSeedHash((Memory)wmem), (short)defaultSeedHash);
    }

    @Test
    public void checkNormalPutMemory() {
        int lgK = 12;
        double kxp = lgK;
        double hipAccum = 1005.0;
        int fiCol = 1;
        int[] csvStream = new int[]{1, 2, 3};
        int numCoupons = csvStream.length;
        int csvLength = csvStream.length;
        short seedHash = defaultSeedHash;
        int[] cwStream = new int[]{4, 5, 6};
        int cwLength = cwStream.length;
        int numSv = cwStream.length;
        int maxInts = 10 + csvLength + cwLength;
        WritableMemory wmem = WritableMemory.allocate((int)(4 * maxInts));
        Format format = Format.EMPTY_MERGED;
        PreambleUtil.putEmptyMerged((WritableMemory)wmem, (int)lgK, (short)seedHash);
        PreambleUtilTest.println(CpcSketch.toString((byte[])((byte[])wmem.getArray()), (boolean)true));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, 0);
        Assert.assertFalse((boolean)PreambleUtil.hasHip((Memory)wmem));
        format = Format.SPARSE_HYBRID_MERGED;
        PreambleUtil.putSparseHybridMerged((WritableMemory)wmem, (int)lgK, (int)numCoupons, (int)csvLength, (short)seedHash, (int[])csvStream);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, 0);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((Memory)wmem), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((Memory)wmem), (int)csvLength);
        format = Format.SPARSE_HYBRID_HIP;
        PreambleUtil.putSparseHybridHip((WritableMemory)wmem, (int)lgK, (int)numCoupons, (int)csvLength, (double)kxp, (double)hipAccum, (short)seedHash, (int[])csvStream);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, 0);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((Memory)wmem), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((Memory)wmem), (int)csvLength);
        Assert.assertEquals((double)PreambleUtil.getKxP((Memory)wmem), (double)kxp);
        Assert.assertEquals((double)PreambleUtil.getHipAccum((Memory)wmem), (double)hipAccum);
        Assert.assertTrue((boolean)PreambleUtil.hasHip((Memory)wmem));
        format = Format.PINNED_SLIDING_MERGED_NOSV;
        PreambleUtil.putPinnedSlidingMergedNoSv((WritableMemory)wmem, (int)lgK, (int)fiCol, (int)numCoupons, (int)cwLength, (short)seedHash, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, fiCol);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((Memory)wmem), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((Memory)wmem), (int)cwLength);
        format = Format.PINNED_SLIDING_HIP_NOSV;
        PreambleUtil.putPinnedSlidingHipNoSv((WritableMemory)wmem, (int)lgK, (int)fiCol, (int)numCoupons, (int)cwLength, (double)kxp, (double)hipAccum, (short)seedHash, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, fiCol);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((Memory)wmem), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((Memory)wmem), (int)cwLength);
        Assert.assertEquals((double)PreambleUtil.getKxP((Memory)wmem), (double)kxp);
        Assert.assertEquals((double)PreambleUtil.getHipAccum((Memory)wmem), (double)hipAccum);
        format = Format.PINNED_SLIDING_MERGED;
        PreambleUtil.putPinnedSlidingMerged((WritableMemory)wmem, (int)lgK, (int)fiCol, (int)numCoupons, (int)numSv, (int)csvLength, (int)cwLength, (short)seedHash, (int[])csvStream, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, fiCol);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((Memory)wmem), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getNumSv((Memory)wmem), (int)numSv);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((Memory)wmem), (int)csvLength);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((Memory)wmem), (int)cwLength);
        format = Format.PINNED_SLIDING_HIP;
        PreambleUtil.putPinnedSlidingHip((WritableMemory)wmem, (int)lgK, (int)fiCol, (int)numCoupons, (int)numSv, (double)kxp, (double)hipAccum, (int)csvLength, (int)cwLength, (short)seedHash, (int[])csvStream, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
        PreambleUtilTest.checkFirst8(wmem, format, lgK, fiCol);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((Memory)wmem), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getNumSv((Memory)wmem), (int)numSv);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((Memory)wmem), (int)csvLength);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((Memory)wmem), (int)cwLength);
        Assert.assertEquals((double)PreambleUtil.getKxP((Memory)wmem), (double)kxp);
        Assert.assertEquals((double)PreambleUtil.getHipAccum((Memory)wmem), (double)hipAccum);
    }

    @Test
    public void checkStreamErrors() {
        WritableMemory wmem = WritableMemory.allocate((int)40);
        PreambleUtil.putEmptyMerged((WritableMemory)wmem, (int)12, (short)defaultSeedHash);
        try {
            PreambleUtil.getSvStreamOffset((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        wmem.putByte(5L, (byte)28);
        try {
            PreambleUtil.getSvStreamOffset((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        wmem.putByte(5L, (byte)0);
        try {
            PreambleUtil.getWStreamOffset((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        wmem.putByte(5L, (byte)28);
        try {
            PreambleUtil.getWStreamOffset((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkStreamErrors2() {
        WritableMemory wmem = WritableMemory.allocate((int)40);
        int[] svStream = new int[]{1};
        int[] wStream = new int[]{2};
        try {
            PreambleUtil.putPinnedSlidingMerged((WritableMemory)wmem, (int)4, (int)0, (int)1, (int)1, (int)1, (int)0, (short)0, (int[])svStream, (int[])wStream);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)PreambleUtil.isCompressed((Memory)wmem));
    }

    @Test
    public void checkEmptyMemory() {
        WritableMemory wmem = WritableMemory.allocate((int)40);
        wmem.putByte(2L, (byte)16);
        wmem.putByte(5L, (byte)4);
        PreambleUtilTest.println(CpcSketch.toString((Memory)wmem, (boolean)false));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkFieldError() {
        PreambleUtil.fieldError((Format)Format.EMPTY_MERGED, (PreambleUtil.HiField)PreambleUtil.HiField.NUM_COUPONS);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCapacity() {
        PreambleUtil.checkCapacity((long)100L, (long)101L);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkHiFieldError() {
        PreambleUtil.getHiFieldOffset((Format)Format.EMPTY_MERGED, (PreambleUtil.HiField)PreambleUtil.HiField.NUM_COUPONS);
    }

    @Test
    public void checkWindowOffset() {
        long offset = CpcUtil.determineCorrectOffset((int)4, (long)54L);
        Assert.assertEquals((long)offset, (long)1L);
    }

    @Test
    public void checkFormatEnum() {
        Assert.assertEquals((Object)Format.EMPTY_MERGED, (Object)Format.ordinalToFormat((int)0));
        Assert.assertEquals((Object)Format.EMPTY_HIP, (Object)Format.ordinalToFormat((int)1));
        Assert.assertEquals((Object)Format.SPARSE_HYBRID_MERGED, (Object)Format.ordinalToFormat((int)2));
        Assert.assertEquals((Object)Format.SPARSE_HYBRID_HIP, (Object)Format.ordinalToFormat((int)3));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_MERGED_NOSV, (Object)Format.ordinalToFormat((int)4));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_HIP_NOSV, (Object)Format.ordinalToFormat((int)5));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_MERGED, (Object)Format.ordinalToFormat((int)6));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_HIP, (Object)Format.ordinalToFormat((int)7));
    }

    @Test
    public void checkFlavorEnum() {
        Assert.assertEquals((Object)Flavor.EMPTY, (Object)Flavor.ordinalToFlavor((int)0));
        Assert.assertEquals((Object)Flavor.SPARSE, (Object)Flavor.ordinalToFlavor((int)1));
        Assert.assertEquals((Object)Flavor.HYBRID, (Object)Flavor.ordinalToFlavor((int)2));
        Assert.assertEquals((Object)Flavor.PINNED, (Object)Flavor.ordinalToFlavor((int)3));
        Assert.assertEquals((Object)Flavor.SLIDING, (Object)Flavor.ordinalToFlavor((int)4));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

