/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationprofilestatus.traits.Deployment;
import org.apache.camel.v1.integrationprofilestatus.traits.deployment.Configuration;
import org.apache.camel.v1.integrationprofilestatus.traits.deployment.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.deployment.ConfigurationFluent;

public class DeploymentFluent<A extends DeploymentFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Integer progressDeadlineSeconds;
    private IntOrString rollingUpdateMaxSurge;
    private IntOrString rollingUpdateMaxUnavailable;
    private Deployment.Strategy strategy;

    public DeploymentFluent() {
    }

    public DeploymentFluent(Deployment instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Deployment instance) {
        Deployment deployment = instance = instance != null ? instance : new Deployment();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
            this.withRollingUpdateMaxSurge(instance.getRollingUpdateMaxSurge());
            this.withRollingUpdateMaxUnavailable(instance.getRollingUpdateMaxUnavailable());
            this.withStrategy(instance.getStrategy());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds != null;
    }

    public IntOrString getRollingUpdateMaxSurge() {
        return this.rollingUpdateMaxSurge;
    }

    public A withRollingUpdateMaxSurge(IntOrString rollingUpdateMaxSurge) {
        this.rollingUpdateMaxSurge = rollingUpdateMaxSurge;
        return (A)((Object)this);
    }

    public boolean hasRollingUpdateMaxSurge() {
        return this.rollingUpdateMaxSurge != null;
    }

    public A withNewRollingUpdateMaxSurge(Object value) {
        return this.withRollingUpdateMaxSurge(new IntOrString(value));
    }

    public IntOrString getRollingUpdateMaxUnavailable() {
        return this.rollingUpdateMaxUnavailable;
    }

    public A withRollingUpdateMaxUnavailable(IntOrString rollingUpdateMaxUnavailable) {
        this.rollingUpdateMaxUnavailable = rollingUpdateMaxUnavailable;
        return (A)((Object)this);
    }

    public boolean hasRollingUpdateMaxUnavailable() {
        return this.rollingUpdateMaxUnavailable != null;
    }

    public A withNewRollingUpdateMaxUnavailable(Object value) {
        return this.withRollingUpdateMaxUnavailable(new IntOrString(value));
    }

    public Deployment.Strategy getStrategy() {
        return this.strategy;
    }

    public A withStrategy(Deployment.Strategy strategy) {
        this.strategy = strategy;
        return (A)((Object)this);
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentFluent that = (DeploymentFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.progressDeadlineSeconds, that.progressDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.rollingUpdateMaxSurge, that.rollingUpdateMaxSurge)) {
            return false;
        }
        if (!Objects.equals(this.rollingUpdateMaxUnavailable, that.rollingUpdateMaxUnavailable)) {
            return false;
        }
        return Objects.equals((Object)this.strategy, (Object)that.strategy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.progressDeadlineSeconds, this.rollingUpdateMaxSurge, this.rollingUpdateMaxUnavailable, this.strategy, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.progressDeadlineSeconds != null) {
            sb.append("progressDeadlineSeconds:");
            sb.append(this.progressDeadlineSeconds + ",");
        }
        if (this.rollingUpdateMaxSurge != null) {
            sb.append("rollingUpdateMaxSurge:");
            sb.append(this.rollingUpdateMaxSurge + ",");
        }
        if (this.rollingUpdateMaxUnavailable != null) {
            sb.append("rollingUpdateMaxUnavailable:");
            sb.append(this.rollingUpdateMaxUnavailable + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append((Object)this.strategy);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

