/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DomainSocketAddress;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.transport.Transport;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;

class EpollTransport
extends Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    EpollTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory, int ioRatio) {
        EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public Class<? extends Channel> channelType(boolean domain) {
        if (domain) {
            return EpollDomainSocketChannel.class;
        }
        return EpollSocketChannel.class;
    }

    @Override
    public Class<? extends ServerChannel> serverChannelType(boolean domain) {
        if (domain) {
            return EpollServerDomainSocketChannel.class;
        }
        return EpollServerSocketChannel.class;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(EpollChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        super.configure(channel, options);
    }

    @Override
    public void configure(NetServerOptions options, ServerBootstrap bootstrap) {
        bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        if (options.isTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN, (Object)(options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0));
        }
        bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.childOption(EpollChannelOption.TCP_CORK, (Object)options.isTcpCork());
        super.configure(options, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, Bootstrap bootstrap) {
        if (options.isTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, (Object)options.isTcpFastOpen());
        }
        bootstrap.option(EpollChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.option(EpollChannelOption.TCP_CORK, (Object)options.isTcpCork());
        super.configure(options, bootstrap);
    }
}

