/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.Map;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.commons.lang3.ObjectUtils;

public class AutoRecoveryStatusService
implements HttpEndpointService {
    protected final ServerConfiguration conf;

    public AutoRecoveryStatusService(ServerConfiguration conf) {
        this.conf = conf;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        return MetadataDrivers.runFunctionWithLedgerManagerFactory(this.conf, ledgerManagerFactory -> {
            try (LedgerUnderreplicationManager ledgerUnderreplicationManager = ledgerManagerFactory.newLedgerUnderreplicationManager();){
                switch (request.getMethod()) {
                    case GET: {
                        HttpServiceResponse httpServiceResponse = this.handleGetStatus(ledgerUnderreplicationManager);
                        return httpServiceResponse;
                    }
                    case PUT: {
                        HttpServiceResponse httpServiceResponse = this.handlePutStatus(request, ledgerUnderreplicationManager);
                        return httpServiceResponse;
                    }
                }
                HttpServiceResponse httpServiceResponse = new HttpServiceResponse("Not found method. Should be GET or PUT method", HttpServer.StatusCode.NOT_FOUND);
                return httpServiceResponse;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException((Throwable)e);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
        });
    }

    private HttpServiceResponse handleGetStatus(LedgerUnderreplicationManager ledgerUnderreplicationManager) throws Exception {
        String body = JsonUtil.toJson((Object)ImmutableMap.of((Object)"enabled", (Object)ledgerUnderreplicationManager.isLedgerReplicationEnabled()));
        return new HttpServiceResponse(body, HttpServer.StatusCode.OK);
    }

    private HttpServiceResponse handlePutStatus(HttpServiceRequest request, LedgerUnderreplicationManager ledgerUnderreplicationManager) throws Exception {
        Map params = (Map)ObjectUtils.defaultIfNull((Object)request.getParams(), Collections.emptyMap());
        String enabled = (String)params.get("enabled");
        if (enabled == null) {
            return new HttpServiceResponse("Param 'enabled' not found in " + params, HttpServer.StatusCode.BAD_REQUEST);
        }
        if (Boolean.parseBoolean(enabled)) {
            if (!ledgerUnderreplicationManager.isLedgerReplicationEnabled()) {
                ledgerUnderreplicationManager.enableLedgerReplication();
            }
        } else if (ledgerUnderreplicationManager.isLedgerReplicationEnabled()) {
            ledgerUnderreplicationManager.disableLedgerReplication();
        }
        String body = JsonUtil.toJson((Object)ImmutableMap.of((Object)"enabled", (Object)ledgerUnderreplicationManager.isLedgerReplicationEnabled()));
        return new HttpServiceResponse(body, HttpServer.StatusCode.OK);
    }
}

