/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.security.auth.login.Configuration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.client.ZooKeeperSaslClient;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthDesignatedClientTest
extends ClientBase {
    @Test
    public void testAuth() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testSaslConfig() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.getChildren("/", false);
            Assert.assertFalse((boolean)zk.getSaslClient().clientTunneledAuthenticationInProgress());
            Assert.assertEquals((Object)zk.getSaslClient().getSaslState(), (Object)ZooKeeperSaslClient.SaslState.COMPLETE);
            Assert.assertNotNull((Object)Configuration.getConfiguration().getAppConfigurationEntry("MyZookeeperClient"));
            Assert.assertSame((Object)zk.getSaslClient().getLoginContext(), (Object)"MyZookeeperClient");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAccessUser() throws Exception {
        System.setProperty("zookeeper.letAnySaslUserDoX", "anyone");
        TestableZooKeeper zk = this.createClient();
        ArrayList<ACL> aclList = new ArrayList<ACL>();
        ACL acl = new ACL(30, new Id("sasl", "fakeuser"));
        ACL acl1 = new ACL(1, new Id("sasl", "anyone"));
        aclList.add(acl);
        aclList.add(acl1);
        try {
            zk.create("/abc", "testData".getBytes(), aclList, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            Assert.fail((String)"Unable to create znode");
        }
        zk.close();
        Thread.sleep(100L);
        zk = this.createClient();
        try {
            zk.setData("/abc", "testData1".getBytes(), -1);
            Assert.fail((String)"Should not be able to set data");
        }
        catch (KeeperException.NoAuthException e) {
            // empty catch block
        }
        try {
            byte[] bytedata = zk.getData("/abc", null, null);
            String data = new String(bytedata);
            Assert.assertTrue((boolean)"testData".equals(data));
        }
        catch (KeeperException e) {
            Assert.fail((String)"failed to get data");
        }
        zk.close();
        Thread.sleep(100L);
        System.setProperty("zookeeper.sasl.client", "false");
        try {
            zk = this.createClient();
            try {
                zk.getData("/abc", null, null);
                Assert.fail((String)"Should not be able to read data when not authenticated");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.close();
        }
        finally {
            System.setProperty("zookeeper.sasl.client", "true");
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.sasl.clientconfig", "MyZookeeperClient");
        try {
            File tmpDir = SaslAuthDesignatedClientTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_myuser=\"mypassword\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"wrongpassword\";\n};MyZookeeperClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"mypassword\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

