/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerMaster;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LearnerHandlerMetricsTest {
    private MockLearnerHandler learnerHandler;
    private long sid = 5L;
    private volatile CountDownLatch allSentLatch = null;

    @Before
    public void setup() throws IOException {
        Leader leader = (Leader)Mockito.mock(Leader.class);
        Mockito.when((Object)leader.getQuorumAuthServer()).thenReturn(null);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getRemoteSocketAddress()).thenReturn((Object)new InetSocketAddress(32));
        BinaryOutputArchive oa = (BinaryOutputArchive)Mockito.mock(BinaryOutputArchive.class);
        ((BinaryOutputArchive)Mockito.doAnswer(invocationOnMock -> {
            Thread.sleep(5L);
            return null;
        }).when((Object)oa)).writeRecord((Record)ArgumentMatchers.any(QuorumPacket.class), ArgumentMatchers.anyString());
        BufferedOutputStream bos = (BufferedOutputStream)Mockito.mock(BufferedOutputStream.class);
        ((BufferedOutputStream)Mockito.doAnswer(invocationOnMock -> {
            if (this.allSentLatch != null) {
                this.allSentLatch.countDown();
            }
            return null;
        }).when((Object)bos)).flush();
        this.learnerHandler = new MockLearnerHandler(socket, leader);
        this.learnerHandler.setOutputArchive(oa);
        this.learnerHandler.setBufferedOutput(bos);
        this.learnerHandler.sid = this.sid;
    }

    @Test
    public void testMetrics() throws InterruptedException {
        ServerMetrics.getMetrics().resetAll();
        for (int i = 0; i < 1001; ++i) {
            this.learnerHandler.queuePacket(new QuorumPacket());
        }
        this.allSentLatch = new CountDownLatch(1);
        this.learnerHandler.startSendingPackets();
        this.allSentLatch.await(8L, TimeUnit.SECONDS);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        String sidStr = Long.toString(this.sid);
        Assert.assertEquals((Object)2L, (Object)values.get("cnt_" + sidStr + "_learner_handler_qp_time_ms"));
        Assert.assertThat((Object)((Long)values.get("max_" + sidStr + "_learner_handler_qp_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(5000L)));
        Assert.assertEquals((Object)1003L, (Object)values.get("cnt_" + sidStr + "_learner_handler_qp_size"));
        Assert.assertEquals((Object)1002L, (Object)values.get("max_" + sidStr + "_learner_handler_qp_size"));
        Assert.assertEquals((Object)0L, (Object)values.get("min_" + sidStr + "_learner_handler_qp_size"));
    }

    class MockLearnerHandler
    extends LearnerHandler {
        MockLearnerHandler(Socket socket, Leader leader) throws IOException {
            super(socket, null, (LearnerMaster)leader);
        }
    }
}

