/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.audit;

import org.apache.zookeeper.audit.AuditEvent;
import org.junit.Assert;
import org.junit.Test;

public class AuditEventTest {
    @Test
    public void testFormat() {
        AuditEvent auditEvent = new AuditEvent(AuditEvent.Result.SUCCESS);
        auditEvent.addEntry(AuditEvent.FieldName.USER, "Value1");
        auditEvent.addEntry(AuditEvent.FieldName.OPERATION, "Value2");
        String actual = auditEvent.toString();
        String expected = "user=Value1\toperation=Value2\tresult=success";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatShouldIgnoreKeyIfValueIsNull() {
        AuditEvent auditEvent = new AuditEvent(AuditEvent.Result.SUCCESS);
        auditEvent.addEntry(AuditEvent.FieldName.USER, null);
        auditEvent.addEntry(AuditEvent.FieldName.OPERATION, "Value2");
        String actual = auditEvent.toString();
        String expected = "operation=Value2\tresult=success";
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

